package de.javafleet.collections;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

/**
 * Challenge-Demo für die Student-Klasse
 * 
 * Uncomment in Main.java um deine Implementierung zu testen!
 */
public class StudentChallenge {
    
    public static void demo() {
        System.out.println("=== Student Challenge Demo ===");
        System.out.println();
        
        // Level 1 Test: equals und hashCode
        System.out.println("--- Level 1: equals/hashCode ---");
        
        Student s1 = new Student(12345, "Max", "Müller", 1.7);
        Student s2 = new Student(12345, "Maximilian", "Mueller", 2.0);  // Gleiche Matrikelnr!
        Student s3 = new Student(67890, "Max", "Müller", 1.7);  // Andere Matrikelnr
        
        System.out.println("s1: " + s1);
        System.out.println("s2: " + s2);
        System.out.println("s3: " + s3);
        System.out.println();
        
        System.out.println("s1.equals(s2) sollte true sein: " + s1.equals(s2));
        System.out.println("s1.equals(s3) sollte false sein: " + s1.equals(s3));
        System.out.println("s1.hashCode() == s2.hashCode(): " + (s1.hashCode() == s2.hashCode()));
        System.out.println();
        
        // HashSet Test
        Set<Student> studenten = new HashSet<>();
        studenten.add(s1);
        studenten.add(s2);  // Duplikat (gleiche Matrikelnr)
        studenten.add(s3);
        
        System.out.println("HashSet.size() sollte 2 sein: " + studenten.size());
        System.out.println("HashSet Inhalt: " + studenten);
        System.out.println();
        
        // Level 2 Test: Comparable
        System.out.println("--- Level 2: Comparable (TreeSet) ---");
        
        // Dieser Code funktioniert nur wenn Student Comparable implementiert!
        // try {
        //     Set<Student> sortiert = new TreeSet<>();
        //     sortiert.add(new Student(1, "Tom", "Müller", 2.0));
        //     sortiert.add(new Student(2, "Anna", "Schmidt", 1.3));
        //     sortiert.add(new Student(3, "Max", "Müller", 1.7));
        //     sortiert.add(new Student(4, "Lisa", "Bauer", 2.3));
        //     
        //     System.out.println("TreeSet (sortiert nach Nachname, Vorname):");
        //     for (Student s : sortiert) {
        //         System.out.println("  " + s);
        //     }
        // } catch (ClassCastException e) {
        //     System.out.println("⚠️ Student implementiert Comparable noch nicht!");
        // }
        
        System.out.println("(Uncomment den TreeSet-Code wenn Level 2 fertig ist)");
        System.out.println();
        
        // Level 3 Test: Comparator nach Note
        System.out.println("--- Level 3: Comparator nach Note ---");
        System.out.println("(Implementiere Student.NACH_NOTE für diesen Test)");
        
        // Set<Student> nachNote = new TreeSet<>(Student.NACH_NOTE);
        // nachNote.add(new Student(1, "Tom", "Müller", 2.0));
        // nachNote.add(new Student(2, "Anna", "Schmidt", 1.3));
        // nachNote.add(new Student(3, "Max", "Müller", 1.7));
        // 
        // System.out.println("TreeSet (sortiert nach Note, beste zuerst):");
        // for (Student s : nachNote) {
        //     System.out.println("  " + s);
        // }
        
        System.out.println();
        System.out.println("🎉 Challenge abgeschlossen!");
    }
}
