package de.javafleet.generics;

/**
 * Eine einfache generische Box-Klasse.
 * 
 * T ist ein Type Parameter - ein Platzhalter für den konkreten Typ,
 * der bei der Verwendung angegeben wird.
 * 
 * Beispiel:
 * Box<String> stringBox = new Box<>();
 * Box<Integer> intBox = new Box<>();
 * 
 * @param <T> Der Typ des Inhalts
 */
public class Box<T> {
    
    private T inhalt;
    
    /**
     * Erstellt eine leere Box.
     */
    public Box() {
        this.inhalt = null;
    }
    
    /**
     * Erstellt eine Box mit Inhalt.
     * @param inhalt Der Inhalt der Box
     */
    public Box(T inhalt) {
        this.inhalt = inhalt;
    }
    
    /**
     * Gibt den Inhalt zurück.
     * @return Der Inhalt (kann null sein)
     */
    public T getInhalt() {
        return inhalt;
    }
    
    /**
     * Setzt den Inhalt.
     * @param inhalt Der neue Inhalt
     */
    public void setInhalt(T inhalt) {
        this.inhalt = inhalt;
    }
    
    /**
     * Prüft ob die Box leer ist.
     * @return true wenn leer
     */
    public boolean isEmpty() {
        return inhalt == null;
    }
    
    @Override
    public String toString() {
        return "Box[" + (inhalt != null ? inhalt : "leer") + "]";
    }
}
