package de.javafleet.generics;

/**
 * Demonstration der generischen Box-Klasse.
 */
public class BoxDemo {
    
    public static void demo() {
        // String-Box
        Box<String> stringBox = new Box<>("Hallo Welt");
        System.out.println("String-Box: " + stringBox);
        String text = stringBox.getInhalt();  // Kein Cast nötig!
        System.out.println("  Inhalt: " + text);
        
        // Integer-Box
        Box<Integer> intBox = new Box<>(42);
        System.out.println("Integer-Box: " + intBox);
        Integer zahl = intBox.getInhalt();  // Kein Cast nötig!
        System.out.println("  Inhalt: " + zahl);
        
        // Leere Box
        Box<Double> leereBox = new Box<>();
        System.out.println("Leere Box: " + leereBox);
        System.out.println("  Ist leer: " + leereBox.isEmpty());
        
        // Box mit eigenem Objekt
        Box<Person> personBox = new Box<>(new Person("Max", 25));
        System.out.println("Person-Box: " + personBox);
        Person person = personBox.getInhalt();
        System.out.println("  Name: " + person.getName());
    }
    
    // Hilfsklasse für Demo
    static class Person {
        private String name;
        private int alter;
        
        public Person(String name, int alter) {
            this.name = name;
            this.alter = alter;
        }
        
        public String getName() { return name; }
        public int getAlter() { return alter; }
        
        @Override
        public String toString() {
            return name + " (" + alter + ")";
        }
    }
}
