package de.javafleet.generics;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;

/**
 * ✅ LÖSUNG: GenericStack<T>
 * 
 * Ein generischer Stack (LIFO - Last In, First Out).
 * 
 * @param <T> Der Elementtyp
 */
public class GenericStack<T> {
    
    private List<T> elements;
    
    /**
     * Erstellt einen leeren Stack.
     */
    public GenericStack() {
        this.elements = new ArrayList<>();
    }
    
    /**
     * Legt ein Element oben auf den Stack.
     */
    public void push(T element) {
        elements.add(element);
    }
    
    /**
     * Entfernt und gibt das oberste Element zurück.
     * 
     * @throws EmptyStackException wenn der Stack leer ist
     */
    public T pop() {
        if (isEmpty()) {
            throw new EmptyStackException();
        }
        return elements.remove(elements.size() - 1);
    }
    
    /**
     * Gibt das oberste Element zurück, ohne es zu entfernen.
     * 
     * @throws EmptyStackException wenn der Stack leer ist
     */
    public T peek() {
        if (isEmpty()) {
            throw new EmptyStackException();
        }
        return elements.get(elements.size() - 1);
    }
    
    /**
     * Prüft ob der Stack leer ist.
     */
    public boolean isEmpty() {
        return elements.isEmpty();
    }
    
    /**
     * Gibt die Anzahl der Elemente zurück.
     */
    public int size() {
        return elements.size();
    }
    
    /**
     * Leert den Stack.
     */
    public void clear() {
        elements.clear();
    }
    
    @Override
    public String toString() {
        return "Stack" + elements + " <- top";
    }
    
    // ========== BONUS Methoden ==========
    
    /**
     * Durchsucht den Stack nach einem Element.
     */
    public boolean contains(T element) {
        return elements.contains(element);
    }
    
    /**
     * Gibt den 1-basierten Index vom Top zurück.
     * Das oberste Element hat Index 1.
     * 
     * @return Position vom Top, oder -1 wenn nicht gefunden
     */
    public int search(T element) {
        for (int i = elements.size() - 1; i >= 0; i--) {
            if (elements.get(i).equals(element)) {
                return elements.size() - i;
            }
        }
        return -1;
    }
}
