package de.javafleet.generics;

import java.util.Objects;

/**
 * ✅ LÖSUNG: Pair<K, V>
 * 
 * Eine generische Pair-Klasse, die zwei Werte unterschiedlicher Typen speichert.
 * 
 * @param <K> Der Typ des Keys (erster Wert)
 * @param <V> Der Typ des Values (zweiter Wert)
 */
public class Pair<K, V> {
    
    private K key;
    private V value;
    
    /**
     * Erstellt ein neues Pair.
     */
    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }
    
    public K getKey() {
        return key;
    }
    
    public V getValue() {
        return value;
    }
    
    public void setKey(K key) {
        this.key = key;
    }
    
    public void setValue(V value) {
        this.value = value;
    }
    
    @Override
    public String toString() {
        return "(" + key + ", " + value + ")";
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        
        Pair<?, ?> other = (Pair<?, ?>) obj;
        return Objects.equals(key, other.key) 
            && Objects.equals(value, other.value);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(key, value);
    }
    
    /**
     * Factory-Methode für kürzere Syntax.
     */
    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<>(key, value);
    }
}
