package de.javafleet.generics;

/**
 * Demo für die Challenge-Klassen.
 * 
 * Aktiviere diese Demo in Main.java, wenn du Pair und GenericStack
 * implementiert hast!
 */
public class ChallengeDemo {
    
    public static void demo() {
        System.out.println("--- Pair<K,V> Demo ---");
        pairDemo();
        
        System.out.println();
        System.out.println("--- GenericStack<T> Demo ---");
        stackDemo();
    }
    
    static void pairDemo() {
        // Pair mit String und Integer
        Pair<String, Integer> alter = new Pair<>("Max", 25);
        System.out.println("Pair: " + alter);
        System.out.println("  Key: " + alter.getKey());
        System.out.println("  Value: " + alter.getValue());
        
        // Pair mit verschiedenen Typen
        Pair<Integer, Boolean> check = new Pair<>(42, true);
        System.out.println("Check: " + check);
        
        // Factory-Methode (wenn implementiert)
        // Pair<String, Double> preis = Pair.of("Kaffee", 3.50);
        // System.out.println("Preis: " + preis);
    }
    
    static void stackDemo() {
        GenericStack<String> stack = new GenericStack<>();
        
        System.out.println("Push: A, B, C");
        stack.push("A");
        stack.push("B");
        stack.push("C");
        System.out.println("Stack: " + stack);
        System.out.println("Size: " + stack.size());
        
        System.out.println("Peek: " + stack.peek());
        System.out.println("Pop: " + stack.pop());
        System.out.println("Stack nach pop: " + stack);
        
        System.out.println("isEmpty: " + stack.isEmpty());
        
        // Stack mit Zahlen
        GenericStack<Integer> zahlen = new GenericStack<>();
        zahlen.push(10);
        zahlen.push(20);
        zahlen.push(30);
        System.out.println("Zahlen-Stack: " + zahlen);
    }
}
