package de.javafleet.generics;

import java.util.List;

/**
 * Demonstration von generischen Methoden.
 */
public class GenericMethodsDemo {
    
    public static void demo() {
        // printArray mit verschiedenen Typen
        String[] namen = {"Max", "Anna", "Tom"};
        Integer[] zahlen = {1, 2, 3, 4, 5};
        
        System.out.println("String-Array:");
        printArray(namen);
        
        System.out.println("Integer-Array:");
        printArray(zahlen);
        
        // getFirst
        List<String> stringListe = List.of("Erster", "Zweiter", "Dritter");
        String erster = getFirst(stringListe);
        System.out.println("Erstes Element: " + erster);
        
        // swap
        String[] vorher = {"A", "B", "C"};
        System.out.println("Vor swap: " + java.util.Arrays.toString(vorher));
        swap(vorher, 0, 2);
        System.out.println("Nach swap(0,2): " + java.util.Arrays.toString(vorher));
    }
    
    /**
     * Generische Methode: Gibt alle Elemente eines Arrays aus.
     * 
     * Beachte: <T> steht VOR dem Rückgabetyp!
     * 
     * @param <T> Der Elementtyp
     * @param array Das Array
     */
    public static <T> void printArray(T[] array) {
        for (T element : array) {
            System.out.println("  - " + element);
        }
    }
    
    /**
     * Generische Methode: Gibt das erste Element einer Liste zurück.
     * 
     * @param <T> Der Elementtyp
     * @param liste Die Liste
     * @return Das erste Element oder null
     */
    public static <T> T getFirst(List<T> liste) {
        if (liste == null || liste.isEmpty()) {
            return null;
        }
        return liste.get(0);
    }
    
    /**
     * Generische Methode: Tauscht zwei Elemente in einem Array.
     * 
     * @param <T> Der Elementtyp
     * @param array Das Array
     * @param i Index des ersten Elements
     * @param j Index des zweiten Elements
     */
    public static <T> void swap(T[] array, int i, int j) {
        T temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}
