package de.javafleet.generics;

import java.util.ArrayList;
import java.util.List;

/**
 * 🎯 CHALLENGE Level 2: GenericStack<T>
 * 
 * Implementiere einen generischen Stack (LIFO - Last In, First Out).
 * 
 * Operationen:
 * - push(T element): Element oben drauflegen
 * - pop(): Oberstes Element entfernen und zurückgeben
 * - peek(): Oberstes Element anschauen (ohne zu entfernen)
 * - isEmpty(): Prüfen ob leer
 * - size(): Anzahl der Elemente
 * 
 * Beispiel:
 * GenericStack<String> stack = new GenericStack<>();
 * stack.push("A");
 * stack.push("B");
 * stack.push("C");
 * stack.pop();  -> "C"
 * stack.peek(); -> "B"
 * 
 * @param <T> Der Elementtyp
 */
public class GenericStack<T> {
    
    // Interne Speicherung mit ArrayList
    private List<T> elements;
    
    /**
     * Erstellt einen leeren Stack.
     */
    public GenericStack() {
        // TODO: Initialisiere die elements-Liste
        this.elements = new ArrayList<>();
    }
    
    /**
     * Legt ein Element oben auf den Stack.
     * 
     * @param element Das Element
     */
    public void push(T element) {
        // TODO: Füge das Element am Ende der Liste hinzu
        // Tipp: Das "Ende" der Liste ist die "Oberseite" des Stacks
    }
    
    /**
     * Entfernt und gibt das oberste Element zurück.
     * 
     * @return Das oberste Element
     * @throws java.util.EmptyStackException wenn der Stack leer ist
     */
    public T pop() {
        // TODO: 
        // 1. Prüfe ob leer -> EmptyStackException
        // 2. Entferne und gib das letzte Element zurück
        // Tipp: elements.remove(elements.size() - 1)
        return null;
    }
    
    /**
     * Gibt das oberste Element zurück, ohne es zu entfernen.
     * 
     * @return Das oberste Element
     * @throws java.util.EmptyStackException wenn der Stack leer ist
     */
    public T peek() {
        // TODO:
        // 1. Prüfe ob leer -> EmptyStackException
        // 2. Gib das letzte Element zurück (ohne zu entfernen)
        return null;
    }
    
    /**
     * Prüft ob der Stack leer ist.
     * 
     * @return true wenn leer
     */
    public boolean isEmpty() {
        // TODO: Implementiere diese Methode
        return true;
    }
    
    /**
     * Gibt die Anzahl der Elemente zurück.
     * 
     * @return Anzahl der Elemente
     */
    public int size() {
        // TODO: Implementiere diese Methode
        return 0;
    }
    
    /**
     * Leert den Stack.
     */
    public void clear() {
        // TODO: Implementiere diese Methode
    }
    
    @Override
    public String toString() {
        // Zeigt den Stack von unten nach oben
        // z.B. "Stack[A, B, C] <- top"
        return "Stack" + elements + " <- top";
    }
    
    // ========================================
    // BONUS Level 3: Weitere Methoden
    // ========================================
    
    /**
     * Durchsucht den Stack nach einem Element.
     * 
     * @param element Das gesuchte Element
     * @return true wenn gefunden
     */
    public boolean contains(T element) {
        // TODO (Bonus): Implementiere diese Methode
        return false;
    }
    
    /**
     * Gibt den 1-basierten Index vom Top zurück.
     * Das oberste Element hat Index 1.
     * 
     * @param element Das gesuchte Element
     * @return Position vom Top (1 = ganz oben), oder -1 wenn nicht gefunden
     */
    public int search(T element) {
        // TODO (Bonus): Implementiere diese Methode
        // Tipp: Durchsuche von hinten nach vorne
        return -1;
    }
}
