package de.javafleet.generics;

/**
 * Java Erweiterte Techniken - Tag 3: Generics
 * 
 * In diesem Projekt lernst du:
 * - Generische Klassen erstellen (Box, Pair)
 * - Generische Methoden schreiben
 * - Bounded Type Parameters (T extends Number)
 * - Wildcards (?, ? extends, ? super)
 * - PECS: Producer Extends, Consumer Super
 * 
 * @author Java Fleet Systems Consulting
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Java Erweiterte Techniken - Tag 3: Generics             ║");
        System.out.println("║  Java Fleet Systems Consulting                           ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        System.out.println();
        
        System.out.println("=== 1. Einfache generische Klasse: Box<T> ===");
        BoxDemo.demo();
        
        System.out.println();
        System.out.println("=== 2. Generische Methoden ===");
        GenericMethodsDemo.demo();
        
        System.out.println();
        System.out.println("=== 3. Bounded Type Parameters ===");
        BoundedDemo.demo();
        
        System.out.println();
        System.out.println("=== 4. Wildcards ===");
        WildcardDemo.demo();
        
        System.out.println();
        System.out.println("=== 5. Deine Challenge: Pair<K,V> und Stack<T> ===");
        System.out.println("Öffne die Klassen 'Pair' und 'GenericStack' und implementiere die TODOs!");
        System.out.println();
        
        // Uncomment um deine Implementierung zu testen:
        // ChallengeDemo.demo();
        
        System.out.println("────────────────────────────────────────────────────────────");
        System.out.println("Geschafft! Weiter geht's mit Tag 4: Lambda-Ausdrücke");
    }
}
