package de.javafleet.generics;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.DisplayName;
import static org.junit.jupiter.api.Assertions.*;

import java.util.EmptyStackException;

/**
 * Tests für die Challenge-Klassen Pair und GenericStack.
 */
public class ChallengeTest {
    
    // ========== Pair Tests ==========
    
    @Test
    @DisplayName("Pair: Konstruktor und Getter")
    void testPairBasics() {
        Pair<String, Integer> pair = new Pair<>("Max", 25);
        
        assertEquals("Max", pair.getKey());
        assertEquals(25, pair.getValue());
    }
    
    @Test
    @DisplayName("Pair: Setter")
    void testPairSetters() {
        Pair<String, Integer> pair = new Pair<>("Max", 25);
        
        pair.setKey("Anna");
        pair.setValue(30);
        
        assertEquals("Anna", pair.getKey());
        assertEquals(30, pair.getValue());
    }
    
    @Test
    @DisplayName("Pair: toString")
    void testPairToString() {
        Pair<String, Integer> pair = new Pair<>("Max", 25);
        String str = pair.toString();
        
        assertTrue(str.contains("Max"), "toString sollte Key enthalten");
        assertTrue(str.contains("25"), "toString sollte Value enthalten");
    }
    
    @Test
    @DisplayName("Pair: Mit null-Werten")
    void testPairWithNull() {
        Pair<String, String> pair = new Pair<>(null, null);
        
        assertNull(pair.getKey());
        assertNull(pair.getValue());
    }
    
    @Test
    @DisplayName("Pair: Factory-Methode of()")
    void testPairFactory() {
        Pair<String, Integer> pair = Pair.of("Test", 42);
        
        assertNotNull(pair);
        assertEquals("Test", pair.getKey());
        assertEquals(42, pair.getValue());
    }
    
    // ========== GenericStack Tests ==========
    
    @Test
    @DisplayName("Stack: push und size")
    void testStackPush() {
        GenericStack<String> stack = new GenericStack<>();
        
        assertTrue(stack.isEmpty());
        assertEquals(0, stack.size());
        
        stack.push("A");
        assertFalse(stack.isEmpty());
        assertEquals(1, stack.size());
        
        stack.push("B");
        stack.push("C");
        assertEquals(3, stack.size());
    }
    
    @Test
    @DisplayName("Stack: peek ohne Entfernen")
    void testStackPeek() {
        GenericStack<String> stack = new GenericStack<>();
        stack.push("A");
        stack.push("B");
        
        assertEquals("B", stack.peek());
        assertEquals(2, stack.size());  // Größe unverändert
        assertEquals("B", stack.peek());  // Immer noch B
    }
    
    @Test
    @DisplayName("Stack: pop entfernt und gibt zurück")
    void testStackPop() {
        GenericStack<String> stack = new GenericStack<>();
        stack.push("A");
        stack.push("B");
        stack.push("C");
        
        assertEquals("C", stack.pop());
        assertEquals(2, stack.size());
        
        assertEquals("B", stack.pop());
        assertEquals(1, stack.size());
        
        assertEquals("A", stack.pop());
        assertTrue(stack.isEmpty());
    }
    
    @Test
    @DisplayName("Stack: LIFO-Reihenfolge")
    void testStackLIFO() {
        GenericStack<Integer> stack = new GenericStack<>();
        
        stack.push(1);
        stack.push(2);
        stack.push(3);
        
        // Last In, First Out
        assertEquals(3, stack.pop());
        assertEquals(2, stack.pop());
        assertEquals(1, stack.pop());
    }
    
    @Test
    @DisplayName("Stack: pop auf leerem Stack wirft Exception")
    void testStackPopEmpty() {
        GenericStack<String> stack = new GenericStack<>();
        
        assertThrows(EmptyStackException.class, () -> stack.pop());
    }
    
    @Test
    @DisplayName("Stack: peek auf leerem Stack wirft Exception")
    void testStackPeekEmpty() {
        GenericStack<String> stack = new GenericStack<>();
        
        assertThrows(EmptyStackException.class, () -> stack.peek());
    }
    
    @Test
    @DisplayName("Stack: clear leert den Stack")
    void testStackClear() {
        GenericStack<String> stack = new GenericStack<>();
        stack.push("A");
        stack.push("B");
        stack.push("C");
        
        stack.clear();
        
        assertTrue(stack.isEmpty());
        assertEquals(0, stack.size());
    }
    
    @Test
    @DisplayName("Stack: mit verschiedenen Typen")
    void testStackDifferentTypes() {
        GenericStack<Double> doubleStack = new GenericStack<>();
        doubleStack.push(1.5);
        doubleStack.push(2.5);
        assertEquals(2.5, doubleStack.pop());
        
        GenericStack<Boolean> boolStack = new GenericStack<>();
        boolStack.push(true);
        boolStack.push(false);
        assertEquals(false, boolStack.pop());
    }
}
