package de.javafleet.lambdas;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * 🎯 CHALLENGE: Lambda-Ausdrücke meistern
 * 
 * Löse die folgenden Aufgaben, indem du die TODOs implementierst.
 * Starte mit Level 1 und arbeite dich hoch!
 */
public class LambdaChallenge {
    
    public static void runChallenges() {
        System.out.println("=== Lambda Challenges ===");
        System.out.println();
        
        level1();
        level2();
        level3();
    }
    
    // ========================================
    // 🟢 LEVEL 1: Einfache Lambdas
    // ========================================
    
    static void level1() {
        System.out.println("--- Level 1: Einfache Lambdas ---");
        
        List<String> namen = new ArrayList<>(List.of("Max", "Anna", "Tom", "Lisa"));
        
        // TODO 1.1: Ersetze null durch ein Lambda, das den String in Großbuchstaben umwandelt
        Function<String, String> toUpper = null;  // s -> ???
        
        // TODO 1.2: Ersetze null durch ein Lambda, das prüft ob der String mit "A" beginnt
        Predicate<String> startetMitA = null;  // s -> ???
        
        // TODO 1.3: Ersetze null durch ein Lambda, das den String mit "Hallo " prefixed ausgibt
        Consumer<String> begruessung = null;  // s -> ???
        
        // Tests (nicht ändern!)
        if (toUpper != null) {
            System.out.println("  1.1 toUpper('test'): " + toUpper.apply("test"));
        }
        if (startetMitA != null) {
            System.out.println("  1.2 startetMitA('Anna'): " + startetMitA.test("Anna"));
            System.out.println("  1.2 startetMitA('Max'): " + startetMitA.test("Max"));
        }
        if (begruessung != null) {
            System.out.print("  1.3 begruessung: ");
            begruessung.accept("Welt");
        }
        
        System.out.println();
    }
    
    // ========================================
    // 🟡 LEVEL 2: Sortieren und Filtern
    // ========================================
    
    static void level2() {
        System.out.println("--- Level 2: Sortieren und Filtern ---");
        
        List<String> woerter = new ArrayList<>(List.of(
            "Java", "ist", "eine", "tolle", "Programmiersprache"
        ));
        
        // TODO 2.1: Sortiere die Liste nach Länge der Wörter (kürzeste zuerst)
        // Tipp: woerter.sort(???)
        
        System.out.println("  2.1 Nach Länge: " + woerter);
        
        // TODO 2.2: Sortiere die Liste alphabetisch (ignoriere Groß/Kleinschreibung)
        // Tipp: String::compareToIgnoreCase oder (a, b) -> a.compareToIgnoreCase(b)
        
        System.out.println("  2.2 Alphabetisch: " + woerter);
        
        // TODO 2.3: Entferne alle Wörter mit weniger als 4 Buchstaben
        // Tipp: woerter.removeIf(???)
        
        System.out.println("  2.3 Ohne kurze Wörter: " + woerter);
        
        System.out.println();
    }
    
    // ========================================
    // 🔵 LEVEL 3: Method References und Chaining
    // ========================================
    
    static void level3() {
        System.out.println("--- Level 3: Method References ---");
        
        List<Produkt> produkte = new ArrayList<>(List.of(
            new Produkt("Laptop", 999.99, "Elektronik"),
            new Produkt("Buch", 19.99, "Medien"),
            new Produkt("Kaffee", 8.99, "Lebensmittel"),
            new Produkt("Smartphone", 799.99, "Elektronik"),
            new Produkt("Tee", 5.99, "Lebensmittel")
        ));
        
        // TODO 3.1: Sortiere Produkte nach Kategorie, dann nach Preis (aufsteigend)
        // Tipp: Comparator.comparing(...).thenComparing(...)
        
        System.out.println("  3.1 Nach Kategorie und Preis:");
        produkte.forEach(p -> System.out.println("      " + p));
        
        // TODO 3.2: Sortiere nach Preis absteigend
        // Tipp: .reversed()
        
        System.out.println("  3.2 Nach Preis (teuerste zuerst):");
        produkte.forEach(p -> System.out.println("      " + p));
        
        // TODO 3.3: Finde alle Produkte unter 20€ und gib nur die Namen aus
        // Tipp: Stream mit filter, map, forEach
        System.out.print("  3.3 Günstige Produkte: ");
        // produkte.stream()
        //     .filter(???)
        //     .map(???)
        //     .forEach(???);
        System.out.println();
        
        System.out.println();
    }
}

/**
 * Hilfsklasse für Level 3.
 */
class Produkt {
    private String name;
    private double preis;
    private String kategorie;
    
    public Produkt(String name, double preis, String kategorie) {
        this.name = name;
        this.preis = preis;
        this.kategorie = kategorie;
    }
    
    public String getName() { return name; }
    public double getPreis() { return preis; }
    public String getKategorie() { return kategorie; }
    
    @Override
    public String toString() {
        return String.format("%s (%.2f€, %s)", name, preis, kategorie);
    }
}
