package de.javafleet.lambdas;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

/**
 * Demonstration der Lambda-Syntax.
 */
public class LambdaSyntaxDemo {
    
    public static void demo() {
        // ===== VERSCHIEDENE LAMBDA-FORMEN =====
        
        // 1. Kein Parameter
        Runnable noParam = () -> System.out.println("  Hallo ohne Parameter!");
        noParam.run();
        
        // 2. Ein Parameter (Klammern optional)
        Consumer<String> einParam = s -> System.out.println("  Eingang: " + s);
        einParam.accept("Test");
        
        // 3. Ein Parameter mit Klammern
        Consumer<String> mitKlammern = (s) -> System.out.println("  Mit Klammern: " + s);
        mitKlammern.accept("Auch OK");
        
        // 4. Mehrere Parameter
        java.util.Comparator<String> mehrereParams = (a, b) -> a.compareTo(b);
        System.out.println("  Vergleich 'A' mit 'B': " + mehrereParams.compare("A", "B"));
        
        // 5. Mit expliziten Typen
        java.util.Comparator<String> mitTypen = (String a, String b) -> a.length() - b.length();
        System.out.println("  Nach Länge: " + mitTypen.compare("Hi", "Hello"));
        
        // 6. Mit Block
        Function<Integer, String> mitBlock = n -> {
            String result = "Zahl: " + n;
            return result.toUpperCase();
        };
        System.out.println("  Mit Block: " + mitBlock.apply(42));
        
        // ===== STANDARD FUNCTIONAL INTERFACES =====
        System.out.println();
        System.out.println("  Standard Functional Interfaces:");
        
        // Predicate: T -> boolean
        Predicate<String> istLeer = s -> s.isEmpty();
        System.out.println("  Predicate - '' ist leer: " + istLeer.test(""));
        
        // Function: T -> R
        Function<String, Integer> laenge = s -> s.length();
        System.out.println("  Function - Länge von 'Hallo': " + laenge.apply("Hallo"));
        
        // Consumer: T -> void
        Consumer<String> drucker = s -> System.out.println("  Consumer: " + s);
        drucker.accept("Ausgabe!");
        
        // Supplier: () -> T
        Supplier<Double> zufall = () -> Math.random();
        System.out.println("  Supplier - Zufallszahl: " + zufall.get());
    }
}
