package de.javafleet.lambdas;

/**
 * Java Erweiterte Techniken - Tag 4: Lambda-Ausdrücke
 * 
 * In diesem Projekt lernst du:
 * - Lambda-Syntax: (parameter) -> ausdruck
 * - Method References: String::toUpperCase
 * - Comparator-Chaining mit Lambdas
 * - Praktische Anwendungen
 * 
 * @author Java Fleet Systems Consulting
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Java Erweiterte Techniken - Tag 4: Lambda-Ausdrücke     ║");
        System.out.println("║  Java Fleet Systems Consulting                           ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        System.out.println();
        
        System.out.println("=== 1. Lambda-Syntax Grundlagen ===");
        LambdaSyntaxDemo.demo();
        
        System.out.println();
        System.out.println("=== 2. Method References ===");
        MethodReferenceDemo.demo();
        
        System.out.println();
        System.out.println("=== 3. Comparator mit Lambdas ===");
        ComparatorDemo.demo();
        
        System.out.println();
        System.out.println("=== 4. Deine Challenge ===");
        System.out.println("Öffne die Klasse 'LambdaChallenge' und löse die Aufgaben!");
        System.out.println();
        
        // Uncomment wenn fertig:
        // LambdaChallenge.runChallenges();
        
        System.out.println("────────────────────────────────────────────────────────────");
        System.out.println("Geschafft! Weiter geht's mit Tag 5: Functional Interfaces");
    }
}
