package de.javafleet.lambdas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Demonstration der vier Method Reference Arten.
 */
public class MethodReferenceDemo {
    
    public static void demo() {
        List<String> namen = new ArrayList<>(Arrays.asList("max", "anna", "tom"));
        
        // ===== 1. STATISCHE METHODE =====
        System.out.println("  1. Statische Methode: ClassName::staticMethod");
        
        // Lambda
        Function<String, Integer> parser1 = s -> Integer.parseInt(s);
        // Method Reference
        Function<String, Integer> parser2 = Integer::parseInt;
        
        System.out.println("     parseInt('42'): " + parser2.apply("42"));
        
        // ===== 2. INSTANZ-METHODE (eines Objekts) =====
        System.out.println("  2. Instanz-Methode (Objekt): object::method");
        
        // System.out ist ein Objekt
        // Lambda: s -> System.out.println(s)
        // Method Reference:
        namen.forEach(System.out::println);
        
        // ===== 3. INSTANZ-METHODE (eines Typs) =====
        System.out.println("  3. Instanz-Methode (Typ): ClassName::method");
        
        // Lambda: s -> s.toUpperCase()
        // Method Reference: String::toUpperCase
        List<String> upper = namen.stream()
            .map(String::toUpperCase)
            .toList();
        System.out.println("     toUpperCase: " + upper);
        
        // ===== 4. KONSTRUKTOR =====
        System.out.println("  4. Konstruktor: ClassName::new");
        
        // Lambda: () -> new ArrayList<>()
        // Method Reference:
        Supplier<ArrayList<String>> factory = ArrayList::new;
        ArrayList<String> neueListe = factory.get();
        neueListe.add("Neu erstellt!");
        System.out.println("     Neue Liste: " + neueListe);
        
        // ===== VERGLEICH: Lambda vs Method Reference =====
        System.out.println();
        System.out.println("  Vergleich Lambda vs Method Reference:");
        
        List<String> daten = List.of("eins", "zwei", "drei");
        
        // Mit Lambda
        System.out.print("     Lambda:    ");
        daten.forEach(s -> System.out.print(s + " "));
        System.out.println();
        
        // Mit Method Reference (eleganter!)
        System.out.print("     MethodRef: ");
        daten.stream()
            .map(String::toUpperCase)
            .forEach(s -> System.out.print(s + " "));
        System.out.println();
    }
}
