package de.javafleet.functional;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

/**
 * Demonstration der vier Basis Functional Interfaces.
 */
public class BasisInterfacesDemo {
    
    public static void demo() {
        // ===== FUNCTION<T, R>: T → R =====
        System.out.println("  Function<T, R>: Transformation");
        
        Function<String, Integer> laenge = s -> s.length();
        Function<String, String> upper = String::toUpperCase;
        Function<Integer, String> zuText = n -> "Zahl: " + n;
        
        System.out.println("    laenge.apply('Hallo'): " + laenge.apply("Hallo"));
        System.out.println("    upper.apply('test'): " + upper.apply("test"));
        System.out.println("    zuText.apply(42): " + zuText.apply(42));
        
        // ===== PREDICATE<T>: T → boolean =====
        System.out.println();
        System.out.println("  Predicate<T>: Bedingung prüfen");
        
        Predicate<String> istLeer = String::isEmpty;
        Predicate<String> istLang = s -> s.length() > 10;
        Predicate<Integer> istGerade = n -> n % 2 == 0;
        
        System.out.println("    istLeer.test(''): " + istLeer.test(""));
        System.out.println("    istLeer.test('Hi'): " + istLeer.test("Hi"));
        System.out.println("    istLang.test('Hallo'): " + istLang.test("Hallo"));
        System.out.println("    istGerade.test(4): " + istGerade.test(4));
        
        // ===== CONSUMER<T>: T → void =====
        System.out.println();
        System.out.println("  Consumer<T>: Verarbeitung (Seiteneffekt)");
        
        Consumer<String> drucker = s -> System.out.println("    → " + s);
        Consumer<String> logger = s -> System.out.println("    [LOG] " + s);
        
        drucker.accept("Hallo Welt");
        logger.accept("Eine Nachricht");
        
        // forEach nutzt Consumer
        List.of("A", "B", "C").forEach(s -> System.out.print("    " + s));
        System.out.println();
        
        // ===== SUPPLIER<T>: () → T =====
        System.out.println();
        System.out.println("  Supplier<T>: Erzeugung (keine Eingabe)");
        
        Supplier<Double> zufall = Math::random;
        Supplier<String> hallo = () -> "Hallo!";
        Supplier<Long> zeit = System::currentTimeMillis;
        
        System.out.println("    zufall.get(): " + zufall.get());
        System.out.println("    hallo.get(): " + hallo.get());
        System.out.println("    zeit.get(): " + zeit.get());
    }
}
