package de.javafleet.functional;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

/**
 * Demonstration von Bi-Varianten und Operatoren.
 */
public class BiVariantenDemo {
    
    public static void demo() {
        // ===== BI-FUNCTION: (T, U) → R =====
        System.out.println("  BiFunction<T, U, R>: Zwei Eingaben, eine Ausgabe");
        
        BiFunction<String, String, String> concat = (a, b) -> a + " " + b;
        BiFunction<Integer, Integer, Integer> addiere = (a, b) -> a + b;
        BiFunction<String, Integer, String> repeat = String::repeat;
        
        System.out.println("    concat.apply('Hallo', 'Welt'): " + 
            concat.apply("Hallo", "Welt"));
        System.out.println("    addiere.apply(3, 4): " + addiere.apply(3, 4));
        System.out.println("    repeat.apply('Ha', 3): " + repeat.apply("Ha", 3));
        
        // ===== BI-PREDICATE: (T, U) → boolean =====
        System.out.println();
        System.out.println("  BiPredicate<T, U>: Zwei Eingaben, boolean");
        
        BiPredicate<String, Integer> laengeOk = (s, max) -> s.length() <= max;
        BiPredicate<Integer, Integer> groesser = (a, b) -> a > b;
        
        System.out.println("    laengeOk.test('Hallo', 10): " + 
            laengeOk.test("Hallo", 10));
        System.out.println("    laengeOk.test('Hallo', 3): " + 
            laengeOk.test("Hallo", 3));
        System.out.println("    groesser.test(5, 3): " + groesser.test(5, 3));
        
        // ===== BI-CONSUMER: (T, U) → void =====
        System.out.println();
        System.out.println("  BiConsumer<T, U>: Zwei Eingaben, kein Rückgabewert");
        
        BiConsumer<String, Integer> ausgabe = (name, alter) -> 
            System.out.println("    → " + name + " ist " + alter + " Jahre alt");
        
        ausgabe.accept("Max", 25);
        ausgabe.accept("Anna", 30);
        
        // ===== UNARY-OPERATOR: T → T =====
        System.out.println();
        System.out.println("  UnaryOperator<T>: Gleicher Ein- und Ausgabetyp");
        
        UnaryOperator<String> upper = String::toUpperCase;
        UnaryOperator<Integer> verdoppeln = n -> n * 2;
        
        System.out.println("    upper.apply('test'): " + upper.apply("test"));
        System.out.println("    verdoppeln.apply(21): " + verdoppeln.apply(21));
        
        // ===== BINARY-OPERATOR: (T, T) → T =====
        System.out.println();
        System.out.println("  BinaryOperator<T>: Zwei gleiche Eingaben, gleiche Ausgabe");
        
        BinaryOperator<Integer> add = (a, b) -> a + b;
        BinaryOperator<String> laengster = (a, b) -> a.length() >= b.length() ? a : b;
        
        System.out.println("    add.apply(3, 4): " + add.apply(3, 4));
        System.out.println("    laengster.apply('Hi', 'Hallo'): " + 
            laengster.apply("Hi", "Hallo"));
    }
}
