package de.javafleet.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

/**
 * 🎯 CHALLENGE: Functional Interfaces meistern
 * 
 * Löse die folgenden Aufgaben, indem du die TODOs implementierst.
 */
public class FunctionalChallenge {
    
    public static void runChallenges() {
        System.out.println("=== Functional Interface Challenges ===");
        System.out.println();
        
        level1();
        level2();
        level3();
    }
    
    // ========================================
    // 🟢 LEVEL 1: Basis-Interfaces
    // ========================================
    
    static void level1() {
        System.out.println("--- Level 1: Basis-Interfaces ---");
        
        // TODO 1.1: Erstelle eine Function, die einen String umkehrt
        // z.B. "Hallo" -> "ollaH"
        Function<String, String> reverse = null;  // s -> ???
        
        // TODO 1.2: Erstelle ein Predicate, das prüft ob eine Zahl positiv ist
        Predicate<Integer> istPositiv = null;  // n -> ???
        
        // TODO 1.3: Erstelle einen Consumer, der "Verarbeite: " + Wert ausgibt
        Consumer<String> verarbeiter = null;  // s -> ???
        
        // TODO 1.4: Erstelle einen Supplier, der die aktuelle Zeit als String liefert
        Supplier<String> zeitStempel = null;  // () -> ???
        
        // Tests
        if (reverse != null) {
            System.out.println("  1.1 reverse('Hallo'): " + reverse.apply("Hallo"));
        }
        if (istPositiv != null) {
            System.out.println("  1.2 istPositiv(5): " + istPositiv.test(5));
            System.out.println("  1.2 istPositiv(-3): " + istPositiv.test(-3));
        }
        if (verarbeiter != null) {
            System.out.print("  1.3 ");
            verarbeiter.accept("Test");
        }
        if (zeitStempel != null) {
            System.out.println("  1.4 zeitStempel: " + zeitStempel.get());
        }
        
        System.out.println();
    }
    
    // ========================================
    // 🟡 LEVEL 2: Komposition
    // ========================================
    
    static void level2() {
        System.out.println("--- Level 2: Komposition ---");
        
        // TODO 2.1: Erstelle eine Pipeline: trim -> toLowerCase -> replace(" ", "_")
        Function<String, String> normalize = null;
        // Tipp: Starte mit einer Function und nutze andThen()
        
        // TODO 2.2: Kombiniere zwei Predicates mit AND:
        // - String nicht leer
        // - String enthält kein Leerzeichen
        Predicate<String> gueltigerUsername = null;
        
        // TODO 2.3: Erstelle eine Filtermethode
        // Nutze die filter-Methode unten und filtere alle geraden Zahlen
        List<Integer> zahlen = List.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        List<Integer> geradeZahlen = null;  // filter(zahlen, ???)
        
        // Tests
        if (normalize != null) {
            System.out.println("  2.1 normalize('  Hello World  '): " + 
                normalize.apply("  Hello World  "));
        }
        if (gueltigerUsername != null) {
            System.out.println("  2.2 gueltig('max_mueller'): " + 
                gueltigerUsername.test("max_mueller"));
            System.out.println("  2.2 gueltig('max mueller'): " + 
                gueltigerUsername.test("max mueller"));
            System.out.println("  2.2 gueltig(''): " + 
                gueltigerUsername.test(""));
        }
        if (geradeZahlen != null) {
            System.out.println("  2.3 geradeZahlen: " + geradeZahlen);
        }
        
        System.out.println();
    }
    
    // ========================================
    // 🔵 LEVEL 3: Eigene Interfaces und Anwendung
    // ========================================
    
    static void level3() {
        System.out.println("--- Level 3: Eigene Interfaces ---");
        
        // TODO 3.1: Implementiere eine map-Methode
        // Nutze die map-Methode unten um alle Strings zu Großbuchstaben zu machen
        List<String> namen = List.of("max", "anna", "tom");
        List<String> upperNamen = null;  // map(namen, ???)
        
        // TODO 3.2: Implementiere das ThrowingSupplier Interface unten
        // und nutze es mit einer Methode die eine Exception werfen könnte
        
        // TODO 3.3: Erstelle eine Funktion höherer Ordnung:
        // Eine Function, die einen Multiplikator nimmt und eine
        // Function zurückgibt, die eine Zahl mit diesem Multiplikator multipliziert
        Function<Integer, Function<Integer, Integer>> multiplikatorFabrik = null;
        // faktor -> (zahl -> zahl * faktor)
        
        // Tests
        if (upperNamen != null) {
            System.out.println("  3.1 upperNamen: " + upperNamen);
        }
        if (multiplikatorFabrik != null) {
            Function<Integer, Integer> mal3 = multiplikatorFabrik.apply(3);
            Function<Integer, Integer> mal7 = multiplikatorFabrik.apply(7);
            System.out.println("  3.3 mal3.apply(10): " + mal3.apply(10));
            System.out.println("  3.3 mal7.apply(10): " + mal7.apply(10));
        }
        
        System.out.println();
    }
    
    // ========================================
    // HILFSMETHODEN (nicht ändern!)
    // ========================================
    
    /**
     * Filtert eine Liste basierend auf einem Predicate.
     */
    public static <T> List<T> filter(List<T> liste, Predicate<T> bedingung) {
        List<T> ergebnis = new ArrayList<>();
        for (T element : liste) {
            if (bedingung.test(element)) {
                ergebnis.add(element);
            }
        }
        return ergebnis;
    }
    
    /**
     * Transformiert eine Liste basierend auf einer Function.
     */
    public static <T, R> List<R> map(List<T> liste, Function<T, R> transformation) {
        List<R> ergebnis = new ArrayList<>();
        for (T element : liste) {
            ergebnis.add(transformation.apply(element));
        }
        return ergebnis;
    }
}

/**
 * 🎯 TODO 3.2: Eigenes Functional Interface mit Exception
 * 
 * Implementiere dieses Interface, das wie Supplier funktioniert,
 * aber Exceptions werfen darf.
 */
@FunctionalInterface
interface ThrowingSupplier<T> {
    // TODO: Deklariere die abstrakte Methode
    // T get() throws Exception;
}
