package de.javafleet.functional;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * Demonstration von Funktionskomposition.
 */
public class KompositionDemo {
    
    public static void demo() {
        // ===== FUNCTION: andThen und compose =====
        System.out.println("  Function: andThen und compose");
        
        Function<String, String> trim = String::trim;
        Function<String, String> upper = String::toUpperCase;
        Function<String, Integer> laenge = String::length;
        
        // andThen: f.andThen(g) = g(f(x))
        Function<String, String> trimDannUpper = trim.andThen(upper);
        System.out.println("    trimDannUpper.apply('  hallo  '): " + 
            trimDannUpper.apply("  hallo  "));
        
        // compose: f.compose(g) = f(g(x))
        Function<String, String> upperDannTrim = trim.compose(upper);
        System.out.println("    upperDannTrim.apply('  hallo  '): " + 
            upperDannTrim.apply("  hallo  "));
        
        // Verkettung
        Function<String, Integer> pipeline = trim.andThen(upper).andThen(laenge);
        System.out.println("    pipeline.apply('  hallo  '): " + 
            pipeline.apply("  hallo  "));
        
        // ===== PREDICATE: and, or, negate =====
        System.out.println();
        System.out.println("  Predicate: and, or, negate");
        
        Predicate<String> nichtLeer = s -> !s.isEmpty();
        Predicate<String> maxLaenge10 = s -> s.length() <= 10;
        Predicate<String> startetMitA = s -> s.startsWith("A");
        
        // and
        Predicate<String> gueltig = nichtLeer.and(maxLaenge10);
        System.out.println("    gueltig.test(''): " + gueltig.test(""));
        System.out.println("    gueltig.test('Hallo'): " + gueltig.test("Hallo"));
        System.out.println("    gueltig.test('Das ist zu lang!'): " + 
            gueltig.test("Das ist zu lang!"));
        
        // or
        Predicate<String> aOderLeer = startetMitA.or(String::isEmpty);
        System.out.println("    aOderLeer.test('Anna'): " + aOderLeer.test("Anna"));
        System.out.println("    aOderLeer.test(''): " + aOderLeer.test(""));
        System.out.println("    aOderLeer.test('Max'): " + aOderLeer.test("Max"));
        
        // negate
        Predicate<String> nichtMitA = startetMitA.negate();
        System.out.println("    nichtMitA.test('Anna'): " + nichtMitA.test("Anna"));
        System.out.println("    nichtMitA.test('Max'): " + nichtMitA.test("Max"));
        
        // ===== CONSUMER: andThen =====
        System.out.println();
        System.out.println("  Consumer: andThen");
        
        Consumer<String> schritt1 = s -> System.out.println("    Schritt 1: " + s);
        Consumer<String> schritt2 = s -> System.out.println("    Schritt 2: " + s.toUpperCase());
        
        Consumer<String> pipeline2 = schritt1.andThen(schritt2);
        pipeline2.accept("test");
    }
}
