package com.javafleet.servlet;

import com.javafleet.model.Product;
import com.javafleet.model.User;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Demo Servlet that provides data for JSP examples.
 * 
 * @author Java Fleet Systems Consulting
 */
@WebServlet("/demo")
public class DemoServlet extends HttpServlet {
    
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        
        // Create sample products
        List<Product> products = new ArrayList<>();
        products.add(new Product("Laptop", 999.99, 5));
        products.add(new Product("Mouse", 29.99, 15));
        products.add(new Product("Keyboard", 79.99, 8));
        products.add(new Product("Monitor", 299.99, 3));
        
        // Create sample users
        List<User> users = new ArrayList<>();
        users.add(new User("Anna Schmidt", "anna@example.com", 28));
        users.add(new User("Max Müller", "max@example.com", 35));
        users.add(new User("Lisa Weber", "lisa@example.com", 24));
        users.add(new User("Tom Fischer", "tom@example.com", 42));
        
        // Set attributes
        request.setAttribute("products", products);
        request.setAttribute("users", users);
        
        // Forward to JSP
        request.getRequestDispatcher("/WEB-INF/demo.jsp")
               .forward(request, response);
    }
}
