package com.javafleet.servlets;

import com.javafleet.model.Product;
import com.javafleet.model.User;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Demo Servlet that prepares data for the JSP demos.
 * 
 * @author Elyndra Valen - Java Fleet Systems Consulting
 */
@WebServlet("")
public class DemoServlet extends HttpServlet {
    
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        
        // Create demo products
        List<Product> products = new ArrayList<>();
        products.add(new Product(1L, "Laptop", 899.99, 15));
        products.add(new Product(2L, "Mouse", 29.99, 50));
        products.add(new Product(3L, "Keyboard", 79.99, 30));
        products.add(new Product(4L, "Monitor", 299.99, 20));
        products.add(new Product(5L, "Webcam", 89.99, 25));
        
        // Create demo users
        List<User> users = new ArrayList<>();
        users.add(new User(1L, "Anna Schmidt", "anna@example.com", 28));
        users.add(new User(2L, "Max Müller", "max@example.com", 35));
        users.add(new User(3L, "Sarah Weber", "sarah@example.com", 24));
        users.add(new User(4L, "Tom Fischer", "tom@example.com", 42));
        
        // Set attributes for JSP
        request.setAttribute("products", products);
        request.setAttribute("users", users);
        
        // Forward to index page
        request.getRequestDispatcher("/index.jsp").forward(request, response);
    }
}
