package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.TagSupport;
import jakarta.servlet.jsp.JspException;
import java.lang.reflect.Method;

/**
 * Defines a column in TableTag (Child tag).
 * 
 * Must be nested inside a TableTag.
 * 
 * Example:
 * <fleet:column property="name" header="Name" />
 * 
 * @author Java Fleet Systems Consulting
 */
public class ColumnTag extends TagSupport {
    
    private String property;
    private String header;
    
    public void setProperty(String property) {
        this.property = property;
    }
    
    public void setHeader(String header) {
        this.header = header;
    }
    
    public String getHeader() {
        return header != null ? header : property;
    }
    
    @Override
    public int doStartTag() throws JspException {
        // Parent-Tag finden
        TableTag parent = (TableTag) findAncestorWithClass(this, TableTag.class);
        
        if (parent == null) {
            throw new JspException("ColumnTag must be nested inside TableTag!");
        }
        
        // Bei Parent registrieren
        parent.addColumn(this);
        
        // Kein Body - nur Config!
        return SKIP_BODY;
    }
    
    /**
     * Holt den Wert der Property vom Item per Reflection.
     */
    public String getValueFromItem(Object item) {
        try {
            // Reflection: getProperty() auf item aufrufen
            String methodName = "get" + 
                property.substring(0, 1).toUpperCase() + 
                property.substring(1);
            
            Method method = item.getClass().getMethod(methodName);
            Object value = method.invoke(item);
            
            return value != null ? value.toString() : "";
            
        } catch (Exception e) {
            return "[Error: " + e.getMessage() + "]";
        }
    }
}
