package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;

/**
 * Repeats body content n times using EVAL_BODY_AGAIN.
 * 
 * Example:
 * <fleet:repeat times="3">
 *     <p>Hello!</p>
 * </fleet:repeat>
 * 
 * Output: <p>Hello!</p> (3 times)
 * 
 * @author Java Fleet Systems Consulting
 */
public class RepeatTag extends BodyTagSupport {
    
    // Attribut
    private int times;
    
    // Counter für Iteration
    private int iteration;
    
    // Setter für Attribut (PFLICHT!)
    public void setTimes(int times) {
        this.times = times;
    }
    
    @Override
    public int doStartTag() throws JspException {
        // Initialisiere Counter
        iteration = 0;
        
        if (times > 0) {
            return EVAL_BODY_BUFFERED;  // Body verarbeiten
        } else {
            return SKIP_BODY;  // times <= 0: Body überspringen
        }
    }
    
    @Override
    public int doAfterBody() throws JspException {
        try {
            // Body-Content holen
            BodyContent bodyContent = getBodyContent();
            String content = bodyContent.getString();
            
            // Content ausgeben
            bodyContent.getEnclosingWriter().write(content);
            
            // Counter erhöhen
            iteration++;
            
            // Buffer leeren für nächste Iteration
            bodyContent.clearBody();
            
            // Noch mal wiederholen?
            if (iteration < times) {
                return EVAL_BODY_AGAIN;  // Ja, nochmal!
            } else {
                return SKIP_BODY;  // Nein, fertig!
            }
            
        } catch (IOException e) {
            throw new JspException("Error in RepeatTag", e);
        }
    }
    
    @Override
    public int doEndTag() throws JspException {
        // Cleanup
        iteration = 0;
        return EVAL_PAGE;
    }
}
