package com.javafleet.tags;

import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;

/**
 * Converts body content to uppercase using BodyTagSupport.
 * 
 * Example:
 * <fleet:uppercaseBody>hello world</fleet:uppercaseBody>
 * Output: HELLO WORLD
 * 
 * @author Java Fleet Systems Consulting
 */
public class UppercaseBodyTag extends BodyTagSupport {
    
    @Override
    public int doStartTag() throws JspException {
        // Tag startet - wir wollen den Body verarbeiten
        return EVAL_BODY_BUFFERED;  // Buffer erstellen!
    }
    
    @Override
    public int doAfterBody() throws JspException {
        try {
            // Body-Content holen
            BodyContent bodyContent = getBodyContent();
            String content = bodyContent.getString();
            
            // In Uppercase umwandeln
            String uppercased = content.toUpperCase();
            
            // In Output-Stream schreiben
            bodyContent.getEnclosingWriter().write(uppercased);
            
            // Fertig - keine weitere Iteration
            return SKIP_BODY;
            
        } catch (IOException e) {
            throw new JspException("Error in UppercaseBodyTag", e);
        }
    }
    
    @Override
    public int doEndTag() throws JspException {
        // Tag endet - normal weitermachen
        return EVAL_PAGE;
    }
}
