<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="fleet" uri="http://javafleet.com/tags" %>
<%@ taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html>
<head>
    <title>Tag 6 - BodyTagSupport Examples</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .container {
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 {
            color: #667eea;
            border-bottom: 3px solid #667eea;
            padding-bottom: 10px;
        }
        h2 {
            color: #764ba2;
            margin-top: 40px;
        }
        .example {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 20px;
            margin: 20px 0;
            border-radius: 8px;
        }
        .example h3 {
            margin-top: 0;
            color: #667eea;
        }
        .output {
            background: white;
            border: 2px solid #e9ecef;
            padding: 15px;
            margin-top: 10px;
            border-radius: 8px;
        }
        .fleet-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .fleet-table th {
            background-color: #667eea;
            color: white;
            padding: 12px;
            text-align: left;
        }
        .fleet-table td {
            padding: 12px;
            border: 1px solid #dee2e6;
        }
        .fleet-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        code {
            background: #f1f3f5;
            padding: 2px 6px;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
        }
        .info-box {
            background: #e7f5ff;
            border: 1px solid #74c0fc;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 Tag 6 - BodyTagSupport Examples</h1>
        <p><strong>Java Web Aufbau - Custom Tags mit BodyTagSupport</strong></p>
        
        <div class="info-box">
            <p><strong>ℹ️ Info:</strong> Diese Seite demonstriert alle Custom Tags aus Tag 6 des Kurses.</p>
            <p>Jedes Beispiel zeigt die JSP-Syntax und das Ergebnis.</p>
        </div>
        
        <!-- Example 1: UppercaseBody -->
        <h2>1. UppercaseBody Tag</h2>
        <div class="example">
            <h3>Beispiel</h3>
            <p><strong>JSP-Code:</strong></p>
            <code>&lt;fleet:uppercaseBody&gt;hello world from java fleet!&lt;/fleet:uppercaseBody&gt;</code>
            
            <p><strong>Ergebnis:</strong></p>
            <div class="output">
                <fleet:uppercaseBody>hello world from java fleet!</fleet:uppercaseBody>
            </div>
        </div>
        
        <!-- Example 2: Repeat -->
        <h2>2. Repeat Tag</h2>
        <div class="example">
            <h3>Beispiel</h3>
            <p><strong>JSP-Code:</strong></p>
            <code>&lt;fleet:repeat times="3"&gt;&lt;p&gt;🎯 This appears 3 times!&lt;/p&gt;&lt;/fleet:repeat&gt;</code>
            
            <p><strong>Ergebnis:</strong></p>
            <div class="output">
                <fleet:repeat times="3">
                    <p>🎯 This appears 3 times!</p>
                </fleet:repeat>
            </div>
        </div>
        
        <div class="example">
            <h3>Dynamisches Beispiel</h3>
            <p><strong>JSP-Code:</strong></p>
            <code>&lt;fleet:repeat times="5"&gt;⭐&lt;/fleet:repeat&gt;</code>
            
            <p><strong>Ergebnis:</strong></p>
            <div class="output">
                <fleet:repeat times="5">⭐</fleet:repeat>
            </div>
        </div>
        
        <!-- Example 3: ForEach -->
        <h2>3. ForEach Tag - Iteration über Collections</h2>
        <div class="example">
            <h3>Beispiel: Products</h3>
            <p><strong>JSP-Code:</strong></p>
            <code>
                &lt;fleet:forEach items="\${products}" var="product"&gt;<br>
                &nbsp;&nbsp;&lt;p&gt;\${product.name}: \${product.price}€ (Stock: \${product.stock})&lt;/p&gt;<br>
                &lt;/fleet:forEach&gt;
            </code>
            
            <p><strong>Ergebnis:</strong></p>
            <div class="output">
                <fleet:forEach items="${products}" var="product">
                    <p><strong>${product.name}</strong>: ${product.price}€ (Stock: ${product.stock})</p>
                </fleet:forEach>
            </div>
        </div>
        
        <!-- Example 4: Table + Column (Nested Tags) -->
        <h2>4. Table + Column Tags - Parent-Child Kommunikation</h2>
        <div class="example">
            <h3>Beispiel: User Table</h3>
            <p><strong>JSP-Code:</strong></p>
            <code>
                &lt;fleet:table items="\${users}"&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="name" header="Name" /&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="email" header="Email" /&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="age" header="Age" /&gt;<br>
                &lt;/fleet:table&gt;
            </code>
            
            <p><strong>Ergebnis:</strong></p>
            <div class="output">
                <fleet:table items="${users}">
                    <fleet:column property="name" header="Name" />
                    <fleet:column property="email" header="Email" />
                    <fleet:column property="age" header="Age" />
                </fleet:table>
            </div>
        </div>
        
        <div class="example">
            <h3>Beispiel: Product Table</h3>
            <p><strong>JSP-Code:</strong></p>
            <code>
                &lt;fleet:table items="\${products}"&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="name" header="Produkt" /&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="price" header="Preis (€)" /&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="stock" header="Lagerbestand" /&gt;<br>
                &lt;/fleet:table&gt;
            </code>
            
            <p><strong>Ergebnis:</strong></p>
            <div class="output">
                <fleet:table items="${products}">
                    <fleet:column property="name" header="Produkt" />
                    <fleet:column property="price" header="Preis (€)" />
                    <fleet:column property="stock" header="Lagerbestand" />
                </fleet:table>
            </div>
        </div>
        
        <!-- Combination Example -->
        <h2>5. Kombinations-Beispiel</h2>
        <div class="example">
            <h3>Nested Tags kombiniert</h3>
            <p><strong>JSP-Code:</strong></p>
            <code>
                &lt;fleet:repeat times="2"&gt;<br>
                &nbsp;&nbsp;&lt;fleet:uppercaseBody&gt;<br>
                &nbsp;&nbsp;&nbsp;&nbsp;&lt;fleet:forEach items="\${products}" var="p"&gt;<br>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\${p.name}<br>
                &nbsp;&nbsp;&nbsp;&nbsp;&lt;/fleet:forEach&gt;<br>
                &nbsp;&nbsp;&lt;/fleet:uppercaseBody&gt;<br>
                &nbsp;&nbsp;&lt;hr&gt;<br>
                &lt;/fleet:repeat&gt;
            </code>
            
            <p><strong>Ergebnis:</strong></p>
            <div class="output">
                <fleet:repeat times="2">
                    <fleet:uppercaseBody>
                        <fleet:forEach items="${products}" var="p">
                            ${p.name}, 
                        </fleet:forEach>
                    </fleet:uppercaseBody>
                    <hr>
                </fleet:repeat>
            </div>
        </div>
        
        <div class="info-box" style="margin-top: 40px;">
            <h3>✅ Alle Tags funktionieren!</h3>
            <p>Du hast gerade alle Custom Tags aus Tag 6 in Aktion gesehen:</p>
            <ul>
                <li><strong>UppercaseBodyTag</strong> - Body Transformation</li>
                <li><strong>RepeatTag</strong> - Iteration mit EVAL_BODY_AGAIN</li>
                <li><strong>ForEachTag</strong> - Collection Iteration</li>
                <li><strong>TableTag + ColumnTag</strong> - Parent-Child Kommunikation</li>
            </ul>
            <p><strong>Source Code:</strong> Alle Tag Handler findest du in <code>src/main/java/com/javafleet/tags/</code></p>
        </div>
        
        <footer style="margin-top: 40px; padding-top: 20px; border-top: 2px solid #e9ecef; text-align: center; color: #6c757d;">
            <p><strong>Java Web Aufbau - Tag 6</strong></p>
            <p>© 2025 Java Fleet Systems Consulting</p>
            <p><a href="https://java-developer.online" style="color: #667eea;">java-developer.online</a></p>
        </footer>
    </div>
</body>
</html>
