<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="fleet" uri="http://javafleet.com/tags" %>
<%@ taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RepeatTag - Advanced Examples</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 { color: #667eea; margin-bottom: 30px; }
        .demo-box {
            background: #f8f9fa;
            padding: 25px;
            border-radius: 12px;
            margin: 25px 0;
            border-left: 5px solid #667eea;
        }
        .demo-box h3 { color: #333; margin-bottom: 15px; }
        .result { background: white; padding: 20px; border-radius: 8px; margin-top: 15px; }
        .star-line { color: #FFD700; font-size: 24px; margin: 5px 0; }
        .back-link {
            display: inline-block;
            margin-top: 30px;
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔄 RepeatTag - Advanced Examples</h1>
        
        <!-- Example 1: Simple Stars -->
        <div class="demo-box">
            <h3>Example 1: Star Rating</h3>
            <p><code>&lt;fleet:repeat times="5"&gt;⭐&lt;/fleet:repeat&gt;</code></p>
            <div class="result">
                <fleet:repeat times="5">⭐</fleet:repeat>
            </div>
        </div>
        
        <!-- Example 2: Building Lists -->
        <div class="demo-box">
            <h3>Example 2: Building a List</h3>
            <p><code>&lt;fleet:repeat times="3"&gt;&lt;li&gt;List Item&lt;/li&gt;&lt;/fleet:repeat&gt;</code></p>
            <div class="result">
                <ul>
                    <fleet:repeat times="3">
                        <li>List Item</li>
                    </fleet:repeat>
                </ul>
            </div>
        </div>
        
        <!-- Example 3: Dynamic Repetition -->
        <div class="demo-box">
            <h3>Example 3: Dynamic Repetition with EL</h3>
            <c:set var="rating" value="4" />
            <p><code>rating = ${rating}</code></p>
            <p><code>&lt;fleet:repeat times="\${rating}"&gt;★&lt;/fleet:repeat&gt;</code></p>
            <div class="result">
                <div class="star-line">
                    <fleet:repeat times="${rating}">★</fleet:repeat>
                    <fleet:repeat times="${5 - rating}">☆</fleet:repeat>
                </div>
            </div>
        </div>
        
        <!-- Example 4: Table Rows -->
        <div class="demo-box">
            <h3>Example 4: Generating Table Rows</h3>
            <div class="result">
                <table border="1" cellpadding="10" style="width: 100%; border-collapse: collapse;">
                    <thead style="background-color: #667eea; color: white;">
                        <tr>
                            <th>Row</th>
                            <th>Content</th>
                        </tr>
                    </thead>
                    <tbody>
                        <fleet:repeat times="5">
                            <tr>
                                <td>Row</td>
                                <td>Sample Data</td>
                            </tr>
                        </fleet:repeat>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Example 5: Nested Repetition -->
        <div class="demo-box">
            <h3>Example 5: Nested Repetition (Grid)</h3>
            <div class="result">
                <fleet:repeat times="3">
                    <div style="margin: 10px 0;">
                        <fleet:repeat times="5">
                            <span style="display: inline-block; width: 40px; height: 40px; 
                                       background: #667eea; margin: 2px; border-radius: 4px;"></span>
                        </fleet:repeat>
                    </div>
                </fleet:repeat>
            </div>
        </div>
        
        <!-- Example 6: With Complex Content -->
        <div class="demo-box">
            <h3>Example 6: Repeating Complex HTML</h3>
            <div class="result">
                <fleet:repeat times="3">
                    <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
                              color: white; padding: 15px; margin: 10px 0; border-radius: 8px;">
                        <h4 style="margin: 0 0 5px 0;">Card Title</h4>
                        <p style="margin: 0;">This is a repeated card with complex HTML structure.</p>
                    </div>
                </fleet:repeat>
            </div>
        </div>
        
        <a href="index.jsp" class="back-link">← Back to Overview</a>
    </div>
</body>
</html>
