<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="fleet" uri="http://javafleet.com/tags" %>
<%@ taglib prefix="c" uri="jakarta.tags.core" %>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tag 6 - BodyTagSupport Examples</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        
        h1 {
            color: #667eea;
            margin-bottom: 10px;
            font-size: 2.5em;
        }
        
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 1.1em;
        }
        
        .demo-section {
            margin: 40px 0;
            padding: 30px;
            background: #f8f9fa;
            border-radius: 12px;
            border-left: 5px solid #667eea;
        }
        
        .demo-section h2 {
            color: #333;
            margin-bottom: 20px;
            font-size: 1.8em;
        }
        
        .demo-section h3 {
            color: #555;
            margin: 20px 0 10px 0;
            font-size: 1.3em;
        }
        
        .result-box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
            border: 1px solid #ddd;
        }
        
        .code-label {
            background: #667eea;
            color: white;
            padding: 8px 15px;
            border-radius: 6px;
            display: inline-block;
            margin-bottom: 10px;
            font-weight: bold;
        }
        
        .fleet-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        
        .fleet-table th {
            background-color: #667eea;
            color: white;
            padding: 12px;
            text-align: left;
        }
        
        .fleet-table td {
            padding: 10px;
            border-bottom: 1px solid #ddd;
        }
        
        .fleet-table tr:hover {
            background-color: #f5f5f5;
        }
        
        .product-card {
            background: white;
            padding: 15px;
            margin: 10px 0;
            border-radius: 8px;
            border-left: 4px solid #764ba2;
        }
        
        .product-card h4 {
            color: #333;
            margin-bottom: 8px;
        }
        
        .product-card p {
            color: #666;
            margin: 5px 0;
        }
        
        .navigation {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #ddd;
            text-align: center;
        }
        
        .navigation a {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            margin: 0 10px;
            font-weight: bold;
            transition: transform 0.2s;
        }
        
        .navigation a:hover {
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎯 Tag 6 - BodyTagSupport Examples</h1>
        <p class="subtitle">Java Web Aufbau - Custom Tags mit BodyTagSupport</p>
        
        <!-- ============================================
             Demo 1: UppercaseBodyTag
             ============================================ -->
        <div class="demo-section">
            <h2>1️⃣ UppercaseBodyTag - Simple Body Transformation</h2>
            
            <h3>JSP Code:</h3>
            <div class="result-box">
                <code>&lt;fleet:uppercaseBody&gt;<br>
                &nbsp;&nbsp;this text will be converted to uppercase!<br>
                &lt;/fleet:uppercaseBody&gt;</code>
            </div>
            
            <h3>Result:</h3>
            <div class="result-box">
                <span class="code-label">Output</span>
                <p>
                    <fleet:uppercaseBody>
                        this text will be converted to uppercase!
                    </fleet:uppercaseBody>
                </p>
            </div>
            
            <h3>With EL:</h3>
            <div class="result-box">
                <span class="code-label">Output</span>
                <p>
                    <fleet:uppercaseBody>
                        Hello from ${pageContext.request.serverName}!
                    </fleet:uppercaseBody>
                </p>
            </div>
        </div>
        
        <!-- ============================================
             Demo 2: RepeatTag
             ============================================ -->
        <div class="demo-section">
            <h2>2️⃣ RepeatTag - Iteration with EVAL_BODY_AGAIN</h2>
            
            <h3>JSP Code:</h3>
            <div class="result-box">
                <code>&lt;fleet:repeat times="5"&gt;<br>
                &nbsp;&nbsp;&lt;p&gt;This appears 5 times!&lt;/p&gt;<br>
                &lt;/fleet:repeat&gt;</code>
            </div>
            
            <h3>Result:</h3>
            <div class="result-box">
                <span class="code-label">Output</span>
                <fleet:repeat times="5">
                    <p style="margin: 5px 0;">⭐ This appears 5 times!</p>
                </fleet:repeat>
            </div>
            
            <h3>With Dynamic Times:</h3>
            <c:set var="repeatCount" value="3" />
            <div class="result-box">
                <span class="code-label">repeatCount = ${repeatCount}</span>
                <fleet:repeat times="${repeatCount}">
                    <p style="margin: 5px 0;">🔄 Dynamic repetition!</p>
                </fleet:repeat>
            </div>
        </div>
        
        <!-- ============================================
             Demo 3: ForEachTag
             ============================================ -->
        <div class="demo-section">
            <h2>3️⃣ ForEachTag - Collection Iteration</h2>
            
            <h3>JSP Code:</h3>
            <div class="result-box">
                <code>&lt;fleet:forEach items="\${products}" var="product"&gt;<br>
                &nbsp;&nbsp;&lt;div class="product-card"&gt;<br>
                &nbsp;&nbsp;&nbsp;&nbsp;&lt;h4&gt;\${product.name}&lt;/h4&gt;<br>
                &nbsp;&nbsp;&nbsp;&nbsp;&lt;p&gt;Price: \${product.price}€&lt;/p&gt;<br>
                &nbsp;&nbsp;&lt;/div&gt;<br>
                &lt;/fleet:forEach&gt;</code>
            </div>
            
            <h3>Result (${products.size()} products):</h3>
            <div class="result-box">
                <span class="code-label">Output</span>
                <fleet:forEach items="${products}" var="product">
                    <div class="product-card">
                        <h4>📦 ${product.name}</h4>
                        <p><strong>Price:</strong> ${product.price}€</p>
                        <p><strong>Stock:</strong> ${product.stock} units</p>
                    </div>
                </fleet:forEach>
            </div>
        </div>
        
        <!-- ============================================
             Demo 4: TableTag + ColumnTag (Nested Tags)
             ============================================ -->
        <div class="demo-section">
            <h2>4️⃣ TableTag + ColumnTag - Parent-Child Communication</h2>
            
            <h3>JSP Code:</h3>
            <div class="result-box">
                <code>&lt;fleet:table items="\${users}"&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="name" header="Name" /&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="email" header="Email" /&gt;<br>
                &nbsp;&nbsp;&lt;fleet:column property="age" header="Age" /&gt;<br>
                &lt;/fleet:table&gt;</code>
            </div>
            
            <h3>Result - User Table (${users.size()} users):</h3>
            <div class="result-box">
                <span class="code-label">Output</span>
                <fleet:table items="${users}">
                    <fleet:column property="name" header="Name" />
                    <fleet:column property="email" header="Email" />
                    <fleet:column property="age" header="Age" />
                </fleet:table>
            </div>
            
            <h3>Result - Product Table:</h3>
            <div class="result-box">
                <span class="code-label">Output</span>
                <fleet:table items="${products}">
                    <fleet:column property="id" header="ID" />
                    <fleet:column property="name" header="Product" />
                    <fleet:column property="price" header="Price (€)" />
                    <fleet:column property="stock" header="Stock" />
                </fleet:table>
            </div>
        </div>
        
        <!-- ============================================
             Navigation
             ============================================ -->
        <div class="navigation">
            <h3 style="margin-bottom: 20px;">Explore More Examples:</h3>
            <a href="demo-repeat.jsp">🔄 Repeat Examples</a>
            <a href="demo-foreach.jsp">🔁 ForEach Examples</a>
            <a href="demo-table.jsp">📊 Table Examples</a>
        </div>
        
        <!-- ============================================
             Footer
             ============================================ -->
        <div style="margin-top: 50px; padding-top: 20px; border-top: 2px solid #ddd; text-align: center; color: #666;">
            <p><strong>Java Web Aufbau - Tag 6</strong></p>
            <p>© 2025 Java Fleet Systems Consulting</p>
            <p style="margin-top: 10px; font-size: 0.9em;">
                Von Elyndra Valen - Senior Developer<br>
                <a href="https://java-developer.online" style="color: #667eea;">java-developer.online</a>
            </p>
        </div>
    </div>
</body>
</html>
