package de.javafleet.streams;

import java.util.Comparator;
import java.util.List;

/**
 * Demonstration: Intermediate Operations.
 */
public class IntermediateDemo {
    
    public static void demo() {
        List<String> namen = List.of("Max", "Anna", "Tom", "Alexandra", "Tim", "Lisa");
        List<Integer> zahlen = List.of(1, 2, 2, 3, 3, 3, 4, 5, 5);
        
        // ===== FILTER =====
        System.out.println("  filter():");
        List<String> mitA = namen.stream()
            .filter(s -> s.contains("a") || s.contains("A"))
            .toList();
        System.out.println("    Namen mit 'a': " + mitA);
        
        List<Integer> gerade = zahlen.stream()
            .filter(n -> n % 2 == 0)
            .toList();
        System.out.println("    Gerade Zahlen: " + gerade);
        
        // ===== MAP =====
        System.out.println("  map():");
        List<String> gross = namen.stream()
            .map(String::toUpperCase)
            .toList();
        System.out.println("    Großbuchstaben: " + gross);
        
        List<Integer> laengen = namen.stream()
            .map(String::length)
            .toList();
        System.out.println("    Längen: " + laengen);
        
        // ===== SORTED =====
        System.out.println("  sorted():");
        List<String> sortiert = namen.stream()
            .sorted()
            .toList();
        System.out.println("    Alphabetisch: " + sortiert);
        
        List<String> nachLaenge = namen.stream()
            .sorted(Comparator.comparing(String::length))
            .toList();
        System.out.println("    Nach Länge: " + nachLaenge);
        
        // ===== DISTINCT =====
        System.out.println("  distinct():");
        List<Integer> unique = zahlen.stream()
            .distinct()
            .toList();
        System.out.println("    Ohne Duplikate: " + unique);
        
        // ===== LIMIT & SKIP =====
        System.out.println("  limit() & skip():");
        List<String> ersteDrei = namen.stream()
            .limit(3)
            .toList();
        System.out.println("    Erste 3: " + ersteDrei);
        
        List<String> ohneDrei = namen.stream()
            .skip(3)
            .toList();
        System.out.println("    Ohne erste 3: " + ohneDrei);
        
        // Pagination: Seite 2 (Index 3-5)
        List<String> seite2 = namen.stream()
            .skip(3)
            .limit(3)
            .toList();
        System.out.println("    Seite 2 (skip 3, limit 3): " + seite2);
        
        // ===== FLATMAP =====
        System.out.println("  flatMap():");
        List<List<Integer>> verschachtelt = List.of(
            List.of(1, 2),
            List.of(3, 4, 5),
            List.of(6)
        );
        List<Integer> flach = verschachtelt.stream()
            .flatMap(List::stream)
            .toList();
        System.out.println("    Verschachtelt geflacht: " + flach);
    }
}
