package de.javafleet.streams;

/**
 * Java Erweiterte Techniken - Tag 6: Stream-API
 * 
 * In diesem Projekt lernst du:
 * - Streams erstellen (aus Collections, Arrays, Generatoren)
 * - Intermediate: filter, map, sorted, distinct, flatMap
 * - Terminal: collect, forEach, reduce, count
 * - Collectors: toList, toMap, groupingBy, joining
 * 
 * @author Java Fleet Systems Consulting
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Java Erweiterte Techniken - Tag 6: Stream-API           ║");
        System.out.println("║  Java Fleet Systems Consulting                           ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        System.out.println();
        
        System.out.println("=== 1. Streams erstellen ===");
        StreamErstellenDemo.demo();
        
        System.out.println();
        System.out.println("=== 2. Intermediate Operations ===");
        IntermediateDemo.demo();
        
        System.out.println();
        System.out.println("=== 3. Terminal Operations ===");
        TerminalDemo.demo();
        
        System.out.println();
        System.out.println("=== 4. Collectors ===");
        CollectorsDemo.demo();
        
        System.out.println();
        System.out.println("=== 5. Deine Challenge ===");
        System.out.println("Öffne die Klasse 'StreamChallenge' und löse die Aufgaben!");
        System.out.println();
        
        // Uncomment wenn fertig:
        // StreamChallenge.runChallenges();
        
        System.out.println("────────────────────────────────────────────────────────────");
        System.out.println("Geschafft! Weiter geht's mit Tag 7: File I/O");
    }
}
