package de.javafleet.streams;

import java.util.List;

/**
 * Hilfsklasse für Stream-Demos.
 */
public class Person {
    private String name;
    private int alter;
    private String abteilung;
    private double gehalt;
    private List<String> hobbies;
    
    public Person(String name, int alter, String abteilung) {
        this(name, alter, abteilung, 0, List.of());
    }
    
    public Person(String name, int alter, String abteilung, double gehalt) {
        this(name, alter, abteilung, gehalt, List.of());
    }
    
    public Person(String name, int alter, String abteilung, double gehalt, List<String> hobbies) {
        this.name = name;
        this.alter = alter;
        this.abteilung = abteilung;
        this.gehalt = gehalt;
        this.hobbies = hobbies;
    }
    
    public String getName() { return name; }
    public int getAlter() { return alter; }
    public String getAbteilung() { return abteilung; }
    public double getGehalt() { return gehalt; }
    public List<String> getHobbies() { return hobbies; }
    
    @Override
    public String toString() {
        return name + " (" + alter + ", " + abteilung + ")";
    }
    
    // Test-Daten
    public static List<Person> getTestPersonen() {
        return List.of(
            new Person("Max", 25, "IT", 55000, List.of("Gaming", "Coding")),
            new Person("Anna", 30, "HR", 48000, List.of("Lesen", "Yoga")),
            new Person("Tom", 28, "IT", 62000, List.of("Fußball", "Gaming")),
            new Person("Lisa", 35, "HR", 52000, List.of("Reisen", "Kochen")),
            new Person("Jan", 22, "IT", 45000, List.of("Coding", "Musik")),
            new Person("Sarah", 29, "Marketing", 51000, List.of("Social Media", "Yoga"))
        );
    }
}
