package de.javafleet.streams;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

/**
 * Demonstration: Streams erstellen.
 */
public class StreamErstellenDemo {
    
    public static void demo() {
        // ===== AUS COLLECTIONS =====
        System.out.println("  Aus Collections:");
        
        List<String> liste = List.of("A", "B", "C");
        Stream<String> streamAusListe = liste.stream();
        System.out.println("    List.stream(): " + streamAusListe.toList());
        
        Set<Integer> set = Set.of(1, 2, 3);
        System.out.println("    Set.stream(): " + set.stream().toList());
        
        Map<String, Integer> map = Map.of("a", 1, "b", 2);
        System.out.println("    Map.entrySet().stream(): " + map.entrySet().stream().toList());
        
        // ===== AUS ARRAYS =====
        System.out.println("  Aus Arrays:");
        
        String[] array = {"X", "Y", "Z"};
        System.out.println("    Arrays.stream(): " + Arrays.stream(array).toList());
        
        int[] zahlen = {1, 2, 3, 4, 5};
        System.out.println("    IntStream sum: " + Arrays.stream(zahlen).sum());
        
        // ===== MIT STREAM.OF =====
        System.out.println("  Mit Stream.of():");
        
        Stream<String> direktStream = Stream.of("Eins", "Zwei", "Drei");
        System.out.println("    Stream.of(): " + direktStream.toList());
        
        // ===== GENERIEREN =====
        System.out.println("  Generieren:");
        
        // Range (wie Python's range)
        System.out.println("    IntStream.range(0, 5): " + 
            IntStream.range(0, 5).boxed().toList());
        System.out.println("    IntStream.rangeClosed(1, 5): " + 
            IntStream.rangeClosed(1, 5).boxed().toList());
        
        // Iterate
        System.out.println("    Stream.iterate (gerade Zahlen): " + 
            Stream.iterate(0, n -> n + 2).limit(5).toList());
        
        // Generate
        System.out.println("    Stream.generate (3x 'X'): " + 
            Stream.generate(() -> "X").limit(3).toList());
    }
}
