package de.javafleet.streams;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * Demonstration: Terminal Operations.
 */
public class TerminalDemo {
    
    public static void demo() {
        List<String> namen = List.of("Max", "Anna", "Tom", "Alexandra");
        List<Integer> zahlen = List.of(1, 2, 3, 4, 5);
        
        // ===== FOREACH =====
        System.out.println("  forEach():");
        System.out.print("    ");
        namen.stream()
            .filter(s -> s.startsWith("A"))
            .forEach(s -> System.out.print(s + " "));
        System.out.println();
        
        // ===== COUNT =====
        System.out.println("  count():");
        long anzahl = namen.stream()
            .filter(s -> s.length() > 3)
            .count();
        System.out.println("    Namen länger als 3: " + anzahl);
        
        // ===== FINDFIRST / FINDANY =====
        System.out.println("  findFirst():");
        Optional<String> erster = namen.stream()
            .filter(s -> s.startsWith("A"))
            .findFirst();
        System.out.println("    Erster mit 'A': " + erster.orElse("keiner"));
        
        // ===== ANYMATCH / ALLMATCH / NONEMATCH =====
        System.out.println("  anyMatch/allMatch/noneMatch():");
        boolean hatAnna = namen.stream().anyMatch(s -> s.equals("Anna"));
        System.out.println("    Enthält 'Anna': " + hatAnna);
        
        boolean alleKurz = namen.stream().allMatch(s -> s.length() < 20);
        System.out.println("    Alle kürzer als 20: " + alleKurz);
        
        boolean keinerLeer = namen.stream().noneMatch(String::isEmpty);
        System.out.println("    Keiner leer: " + keinerLeer);
        
        // ===== MIN / MAX =====
        System.out.println("  min()/max():");
        Optional<String> laengster = namen.stream()
            .max(Comparator.comparing(String::length));
        System.out.println("    Längster Name: " + laengster.orElse("keiner"));
        
        Optional<Integer> min = zahlen.stream().min(Integer::compareTo);
        System.out.println("    Minimum: " + min.orElse(0));
        
        // ===== REDUCE =====
        System.out.println("  reduce():");
        int summe = zahlen.stream()
            .reduce(0, Integer::sum);
        System.out.println("    Summe: " + summe);
        
        int produkt = zahlen.stream()
            .reduce(1, (a, b) -> a * b);
        System.out.println("    Produkt: " + produkt);
        
        String concat = namen.stream()
            .reduce("", (a, b) -> a + b);
        System.out.println("    Concat: " + concat);
    }
}
