package de.javafleet.fileio;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;

/**
 * Demonstration: Dateien lesen.
 */
public class LesenDemo {
    
    public static void demo() {
        Path textDatei = Path.of("testdaten/beispiel.txt");
        
        // ===== ALLES AUF EINMAL LESEN =====
        System.out.println("  readAllLines():");
        try {
            List<String> zeilen = Files.readAllLines(textDatei, StandardCharsets.UTF_8);
            System.out.println("    Anzahl Zeilen: " + zeilen.size());
            System.out.println("    Erste Zeile: " + zeilen.get(0));
        } catch (IOException e) {
            System.out.println("    Fehler: " + e.getMessage());
        }
        
        // ===== ALS STRING LESEN =====
        System.out.println("  readString():");
        try {
            String inhalt = Files.readString(textDatei);
            System.out.println("    Länge: " + inhalt.length() + " Zeichen");
        } catch (IOException e) {
            System.out.println("    Fehler: " + e.getMessage());
        }
        
        // ===== MIT STREAM (für große Dateien) =====
        System.out.println("  Files.lines() mit Stream:");
        try (Stream<String> lines = Files.lines(textDatei)) {
            long nichtLeer = lines
                .filter(line -> !line.isBlank())
                .filter(line -> !line.startsWith("#"))
                .count();
            System.out.println("    Nicht-leere, nicht-Kommentar Zeilen: " + nichtLeer);
        } catch (IOException e) {
            System.out.println("    Fehler: " + e.getMessage());
        }
        
        // ===== MIT BUFFEREDREADER =====
        System.out.println("  BufferedReader:");
        try (BufferedReader reader = Files.newBufferedReader(textDatei, StandardCharsets.UTF_8)) {
            String ersteLine = reader.readLine();
            String zweiteLine = reader.readLine();
            System.out.println("    Zeile 1: " + ersteLine);
            System.out.println("    Zeile 2: " + zweiteLine);
        } catch (IOException e) {
            System.out.println("    Fehler: " + e.getMessage());
        }
        
        // ===== CSV LESEN =====
        System.out.println("  CSV lesen:");
        Path csvDatei = Path.of("testdaten/mitarbeiter.csv");
        try (Stream<String> lines = Files.lines(csvDatei)) {
            lines.skip(1)  // Header überspringen
                .limit(3)   // Nur erste 3
                .map(line -> line.split(";"))
                .forEach(parts -> System.out.println("    " + parts[0] + " (" + parts[2] + ")"));
        } catch (IOException e) {
            System.out.println("    Fehler: " + e.getMessage());
        }
    }
}
