package de.javafleet.fileio;

/**
 * Java Erweiterte Techniken - Tag 7: File I/O
 * 
 * In diesem Projekt lernst du:
 * - Path und Files für moderne Dateioperationen
 * - Textdateien lesen und schreiben
 * - Properties-Dateien laden und speichern
 * - Verzeichnisse erstellen und durchlaufen
 * 
 * @author Java Fleet Systems Consulting
 */
public class Main {
    
    public static void main(String[] args) {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Java Erweiterte Techniken - Tag 7: File I/O             ║");
        System.out.println("║  Java Fleet Systems Consulting                           ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        System.out.println();
        
        System.out.println("=== 1. Path Grundlagen ===");
        PathDemo.demo();
        
        System.out.println();
        System.out.println("=== 2. Dateien lesen ===");
        LesenDemo.demo();
        
        System.out.println();
        System.out.println("=== 3. Dateien schreiben ===");
        SchreibenDemo.demo();
        
        System.out.println();
        System.out.println("=== 4. Properties ===");
        PropertiesDemo.demo();
        
        System.out.println();
        System.out.println("=== 5. Verzeichnisse ===");
        VerzeichnisDemo.demo();
        
        System.out.println();
        System.out.println("=== 6. Deine Challenge ===");
        System.out.println("Öffne die Klasse 'FileIOChallenge' und löse die Aufgaben!");
        System.out.println();
        
        // Uncomment wenn fertig:
        // FileIOChallenge.runChallenges();
        
        System.out.println("────────────────────────────────────────────────────────────");
        System.out.println("Geschafft! Weiter geht's mit Tag 8: Annotations & Multithreading");
    }
}
