package de.javafleet.fileio;

import java.nio.file.Files;
import java.nio.file.Path;

/**
 * Demonstration: Path und Paths.
 */
public class PathDemo {
    
    public static void demo() {
        // ===== PATH ERSTELLEN =====
        System.out.println("  Path erstellen:");
        
        Path path1 = Path.of("testdaten", "beispiel.txt");
        Path path2 = Path.of("testdaten/beispiel.txt");
        
        System.out.println("    Path.of('testdaten', 'beispiel.txt'): " + path1);
        System.out.println("    Path.of('testdaten/beispiel.txt'): " + path2);
        
        // ===== PATH INFORMATIONEN =====
        System.out.println("  Path Informationen:");
        
        System.out.println("    getFileName(): " + path1.getFileName());
        System.out.println("    getParent(): " + path1.getParent());
        System.out.println("    getNameCount(): " + path1.getNameCount());
        System.out.println("    toAbsolutePath(): " + path1.toAbsolutePath());
        
        // ===== PFADE KOMBINIEREN =====
        System.out.println("  Pfade kombinieren:");
        
        Path base = Path.of("projekt");
        Path resolved = base.resolve("src/main/java");
        System.out.println("    base.resolve('src/main/java'): " + resolved);
        
        // ===== PFAD NORMALISIEREN =====
        System.out.println("  Normalisieren:");
        
        Path messy = Path.of("projekt/../projekt/./src//Main.java");
        Path clean = messy.normalize();
        System.out.println("    Vorher: " + messy);
        System.out.println("    Nachher: " + clean);
        
        // ===== DATEI PRÜFUNGEN =====
        System.out.println("  Prüfungen:");
        
        Path testFile = Path.of("testdaten/beispiel.txt");
        System.out.println("    exists(): " + Files.exists(testFile));
        System.out.println("    isRegularFile(): " + Files.isRegularFile(testFile));
        System.out.println("    isDirectory(): " + Files.isDirectory(testFile));
        System.out.println("    isReadable(): " + Files.isReadable(testFile));
    }
}
