package de.javafleet.annotationsthreads.annotations;

import java.lang.reflect.*;

/**
 * ✅ LÖSUNG: Annotations Challenges
 */
public class AnnotationsChallenge {
    
    public static void runChallenges() throws Exception {
        System.out.println("=== Annotations Challenges - LÖSUNGEN ===");
        System.out.println();
        
        level1();
        level2();
    }
    
    static void level1() {
        System.out.println("--- Level 1: @Author Annotation ---");
        
        // @Author per Reflection auslesen
        Class<?> clazz = MeineKlasse.class;
        
        if (clazz.isAnnotationPresent(Author.class)) {
            Author author = clazz.getAnnotation(Author.class);
            System.out.println("  Klasse: " + clazz.getSimpleName());
            System.out.println("  Autor: " + author.name());
            System.out.println("  Datum: " + author.date());
        }
        
        System.out.println();
    }
    
    static void level2() throws Exception {
        System.out.println("--- Level 2: @Benchmark Processor ---");
        
        BenchmarkDemo demo = new BenchmarkDemo();
        runBenchmarks(demo);
        
        System.out.println();
    }
    
    /**
     * Führt alle @Benchmark Methoden aus und misst die Zeit.
     */
    private static void runBenchmarks(Object obj) throws Exception {
        Class<?> clazz = obj.getClass();
        
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Benchmark.class)) {
                Benchmark benchmark = method.getAnnotation(Benchmark.class);
                int iterations = benchmark.iterations();
                
                System.out.println("  Benchmark: " + method.getName() + " (" + iterations + " Iterationen)");
                
                long totalTime = 0;
                for (int i = 0; i < iterations; i++) {
                    long start = System.nanoTime();
                    method.invoke(obj);
                    long end = System.nanoTime();
                    totalTime += (end - start);
                }
                
                double avgMs = (totalTime / iterations) / 1_000_000.0;
                System.out.printf("    Durchschnitt: %.3f ms%n", avgMs);
            }
        }
    }
}

// ===== MIT @AUTHOR ANNOTIERTE KLASSE =====

@Author(name = "Max Mustermann", date = "2025-01-20")
class MeineKlasse {
    public void tuWas() {
        System.out.println("Tue etwas...");
    }
}

// ===== BENCHMARK DEMO =====

class BenchmarkDemo {
    
    @Benchmark(iterations = 5)
    public void schnelleMethode() {
        // Simuliert schnelle Operation
        int sum = 0;
        for (int i = 0; i < 1000; i++) {
            sum += i;
        }
    }
    
    @Benchmark(iterations = 3)
    public void langsameMethode() {
        // Simuliert langsamere Operation
        try {
            Thread.sleep(10);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
    
    @Benchmark  // Default: 1 Iteration
    public void stringKonkatenation() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10000; i++) {
            sb.append(i);
        }
    }
}
