package de.javafleet.annotationsthreads.annotations;

import java.util.ArrayList;
import java.util.List;

/**
 * Demonstration: Built-in Annotations.
 */
public class BuiltInAnnotationsDemo {
    
    public static void demo() {
        System.out.println("  Built-in Annotations:");
        
        // @Override Demo
        Tier hund = new Hund();
        hund.sprechen();
        
        // @Deprecated Demo
        AlteKlasse alte = new AlteKlasse();
        System.out.println("  @Deprecated Methode: " + alte.alteMethode());
        System.out.println("  Neue Methode: " + alte.neueMethode());
        
        // @SuppressWarnings Demo
        System.out.println("  @SuppressWarnings: Unterdrückt Compiler-Warnungen");
        demonstrateSuppressWarnings();
        
        // @FunctionalInterface Demo
        Berechnung add = (a, b) -> a + b;
        Berechnung mult = (a, b) -> a * b;
        System.out.println("  @FunctionalInterface: 5 + 3 = " + add.berechne(5, 3));
        System.out.println("  @FunctionalInterface: 5 * 3 = " + mult.berechne(5, 3));
    }
    
    @SuppressWarnings({"unchecked", "rawtypes"})
    private static void demonstrateSuppressWarnings() {
        // Ohne @SuppressWarnings würde hier eine Warnung erscheinen
        List rawList = new ArrayList();  // Raw type
        rawList.add("Text");
        System.out.println("    Raw List (Warnung unterdrückt): " + rawList);
    }
}

// ===== HILFSKLASSEN =====

class Tier {
    public void sprechen() {
        System.out.println("  Tier macht Geräusch...");
    }
}

class Hund extends Tier {
    @Override  // Compiler prüft: Existiert diese Methode in Tier?
    public void sprechen() {
        System.out.println("  @Override: Hund sagt Wuff!");
    }
}

class AlteKlasse {
    /**
     * @deprecated Verwende stattdessen {@link #neueMethode()}
     */
    @Deprecated(since = "1.0", forRemoval = true)
    public String alteMethode() {
        return "Veraltet!";
    }
    
    public String neueMethode() {
        return "Modern!";
    }
}

@FunctionalInterface
interface Berechnung {
    int berechne(int a, int b);
    
    // Default-Methoden erlaubt
    default void info() {
        System.out.println("Eine Berechnung");
    }
}
