package de.javafleet.annotationsthreads.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

/**
 * ✅ LÖSUNG: Threads Challenges
 */
public class ThreadsChallenge {
    
    public static void runChallenges() throws Exception {
        System.out.println("=== Threads Challenges - LÖSUNGEN ===");
        System.out.println();
        
        level1();
        level2();
        level3();
    }
    
    static void level1() throws InterruptedException {
        System.out.println("--- Level 1: Threads erstellen ---");
        
        // 1.1 & 1.2 & 1.3: 3 Threads mit Zählung und Verzögerung
        System.out.println("  1.1-1.3 Zähler-Threads:");
        
        List<Thread> threads = new ArrayList<>();
        
        for (int t = 1; t <= 3; t++) {
            final String threadName = "Zähler-" + t;
            Thread thread = new Thread(() -> {
                for (int i = 1; i <= 5; i++) {
                    System.out.println("    " + threadName + ": " + i);
                    try {
                        Thread.sleep(200);  // 200ms Verzögerung
                    } catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            });
            threads.add(thread);
            thread.start();
        }
        
        // Auf alle warten
        for (Thread thread : threads) {
            thread.join();
        }
        
        System.out.println("  Alle Threads beendet!");
        System.out.println();
    }
    
    static void level2() throws Exception {
        System.out.println("--- Level 2: ExecutorService ---");
        
        // 2.1: FixedThreadPool erstellen
        ExecutorService executor = Executors.newFixedThreadPool(4);
        
        // 2.2: 10 Aufgaben einreichen
        System.out.println("  10 Tasks an Pool mit 4 Threads:");
        for (int i = 1; i <= 10; i++) {
            final int taskId = i;
            executor.execute(() -> {
                System.out.println("    Task " + taskId + " in " 
                    + Thread.currentThread().getName());
                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        
        // 2.3 & 2.4: Shutdown und warten
        executor.shutdown();
        executor.awaitTermination(5, TimeUnit.SECONDS);
        System.out.println("  Pool beendet!");
        
        System.out.println();
    }
    
    static void level3() throws Exception {
        System.out.println("--- Level 3: Callable und Future ---");
        
        // 3.1: ExecutorService erstellen
        ExecutorService executor = Executors.newFixedThreadPool(3);
        
        // 3.2: 5 Callables für Quadratzahlen
        List<Callable<Integer>> aufgaben = new ArrayList<>();
        for (int i = 1; i <= 5; i++) {
            final int zahl = i;
            aufgaben.add(() -> {
                Thread.sleep(100);  // Simulierte Berechnung
                return zahl * zahl;
            });
        }
        
        // 3.3: Alle Futures sammeln und summieren
        List<Future<Integer>> futures = executor.invokeAll(aufgaben);
        
        int summe = 0;
        System.out.println("  Quadratzahlen:");
        for (int i = 0; i < futures.size(); i++) {
            int quadrat = futures.get(i).get();
            System.out.println("    " + (i+1) + "² = " + quadrat);
            summe += quadrat;
        }
        System.out.println("  Summe: " + summe);  // 1+4+9+16+25 = 55
        
        // 3.4: invokeAny für schnellstes Ergebnis
        System.out.println();
        System.out.println("  Rennen (invokeAny):");
        
        List<Callable<String>> rennen = List.of(
            () -> { Thread.sleep(300); return "Langsam"; },
            () -> { Thread.sleep(50);  return "Schnell"; },
            () -> { Thread.sleep(150); return "Mittel"; }
        );
        
        String gewinner = executor.invokeAny(rennen);
        System.out.println("    Gewinner: " + gewinner);
        
        executor.shutdown();
        executor.awaitTermination(5, TimeUnit.SECONDS);
        
        System.out.println();
    }
}
