package de.javafleet.annotationsthreads;

import de.javafleet.annotationsthreads.annotations.*;
import de.javafleet.annotationsthreads.threads.*;

/**
 * Java Erweiterte Techniken - Tag 8: Annotations & Multithreading
 * 
 * In diesem Projekt lernst du:
 * - Built-in Annotations (@Override, @Deprecated, etc.)
 * - Eigene Annotations erstellen
 * - Threads mit Thread und Runnable
 * - ExecutorService und Thread-Pools
 * - Callable und Future
 * 
 * @author Java Fleet Systems Consulting
 */
public class Main {
    
    public static void main(String[] args) throws Exception {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Java Erweiterte Techniken - Tag 8                       ║");
        System.out.println("║  Annotations & Multithreading Basics                     ║");
        System.out.println("║  Java Fleet Systems Consulting                           ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        System.out.println();
        
        // ========== TEIL 1: ANNOTATIONS ==========
        System.out.println("═══════════════════════════════════════════════════════════");
        System.out.println("  TEIL 1: ANNOTATIONS");
        System.out.println("═══════════════════════════════════════════════════════════");
        System.out.println();
        
        System.out.println("=== 1. Built-in Annotations ===");
        BuiltInAnnotationsDemo.demo();
        
        System.out.println();
        System.out.println("=== 2. Eigene Annotations ===");
        CustomAnnotationsDemo.demo();
        
        // ========== TEIL 2: MULTITHREADING ==========
        System.out.println();
        System.out.println("═══════════════════════════════════════════════════════════");
        System.out.println("  TEIL 2: MULTITHREADING BASICS");
        System.out.println("═══════════════════════════════════════════════════════════");
        System.out.println();
        
        System.out.println("=== 3. Threads erstellen ===");
        ThreadBasicsDemo.demo();
        
        System.out.println();
        System.out.println("=== 4. ExecutorService ===");
        ExecutorServiceDemo.demo();
        
        System.out.println();
        System.out.println("=== 5. Callable und Future ===");
        CallableFutureDemo.demo();
        
        System.out.println();
        System.out.println("=== 6. Deine Challenge ===");
        System.out.println("Öffne 'AnnotationsChallenge' und 'ThreadsChallenge' für Übungen!");
        System.out.println();
        
        // Uncomment wenn fertig:
        // AnnotationsChallenge.runChallenges();
        // ThreadsChallenge.runChallenges();
        
        System.out.println("────────────────────────────────────────────────────────────");
        System.out.println("Geschafft! Weiter geht's mit Tag 9: Synchronisation");
    }
}
