package de.javafleet.annotationsthreads.annotations;

import java.lang.annotation.*;

/**
 * Annotation zur Messung der Ausführungszeit.
 * 
 * Verwendung:
 * @LogExecutionTime("Meine Operation")
 * public void meineMethode() { ... }
 */
@Retention(RetentionPolicy.RUNTIME)  // Zur Laufzeit per Reflection lesbar
@Target(ElementType.METHOD)           // Nur auf Methoden anwendbar
@Documented                           // In Javadoc aufnehmen
public @interface LogExecutionTime {
    
    /**
     * Beschreibung der Operation.
     */
    String value() default "";
    
    /**
     * Ob Logging aktiviert ist.
     */
    boolean enabled() default true;
}
