package de.javafleet.annotationsthreads.threads;

import java.util.concurrent.*;

/**
 * Demonstration: ExecutorService und Thread-Pools.
 */
public class ExecutorServiceDemo {
    
    public static void demo() throws InterruptedException {
        // === FIXEDTHREADPOOL ===
        System.out.println("  FixedThreadPool (4 Threads):");
        
        ExecutorService executor = Executors.newFixedThreadPool(4);
        
        // 8 Aufgaben an Pool mit 4 Threads
        for (int i = 1; i <= 8; i++) {
            final int taskId = i;
            executor.execute(() -> {
                System.out.println("    Task " + taskId + " läuft in " 
                    + Thread.currentThread().getName());
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        
        // Pool ordentlich beenden!
        executor.shutdown();
        executor.awaitTermination(5, TimeUnit.SECONDS);
        
        // === VERSCHIEDENE POOL-TYPEN ===
        System.out.println();
        System.out.println("  Verschiedene Pool-Typen:");
        
        // CachedThreadPool - dynamisch wachsend
        ExecutorService cached = Executors.newCachedThreadPool();
        System.out.println("    CachedThreadPool: Dynamisch wachsend");
        cached.execute(() -> System.out.println("      Cached-Task läuft"));
        cached.shutdown();
        cached.awaitTermination(1, TimeUnit.SECONDS);
        
        // SingleThreadExecutor - ein Thread für Queue-Verarbeitung
        ExecutorService single = Executors.newSingleThreadExecutor();
        System.out.println("    SingleThreadExecutor: Ein Thread für Queue");
        single.execute(() -> System.out.println("      Single-Task 1"));
        single.execute(() -> System.out.println("      Single-Task 2"));
        single.shutdown();
        single.awaitTermination(1, TimeUnit.SECONDS);
        
        // === SCHEDULED EXECUTOR ===
        System.out.println();
        System.out.println("  ScheduledExecutorService:");
        
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        
        // Einmalig nach 500ms
        scheduler.schedule(
            () -> System.out.println("    Verzögerte Aufgabe (nach 500ms)"),
            500, TimeUnit.MILLISECONDS
        );
        
        // Auf Ausführung warten
        Thread.sleep(700);
        
        scheduler.shutdown();
        scheduler.awaitTermination(1, TimeUnit.SECONDS);
        
        System.out.println("    Alle Pools beendet.");
    }
}
