package de.javafleet.annotationsthreads.threads;

/**
 * Demonstration: Threads erstellen und starten.
 */
public class ThreadBasicsDemo {
    
    public static void demo() throws InterruptedException {
        System.out.println("  Aktueller Thread: " + Thread.currentThread().getName());
        
        // === METHODE 1: Thread-Klasse erweitern ===
        System.out.println();
        System.out.println("  Methode 1: Thread-Klasse erweitern");
        
        ZaehlerThread t1 = new ZaehlerThread("Thread-A", 3);
        ZaehlerThread t2 = new ZaehlerThread("Thread-B", 3);
        
        System.out.println("    Status vor start(): " + t1.getState());
        
        t1.start();  // NICHT run() aufrufen!
        t2.start();
        
        System.out.println("    Status nach start(): " + t1.getState());
        
        // Warten bis beide fertig
        t1.join();
        t2.join();
        
        System.out.println("    Status nach join(): " + t1.getState());
        
        // === METHODE 2: Runnable (bevorzugt!) ===
        System.out.println();
        System.out.println("  Methode 2: Runnable implementieren (bevorzugt!)");
        
        Runnable aufgabe = new MeineAufgabe("Runnable-Task");
        Thread t3 = new Thread(aufgabe);
        t3.start();
        t3.join();
        
        // === METHODE 3: Lambda (am elegantesten) ===
        System.out.println();
        System.out.println("  Methode 3: Lambda-Ausdruck");
        
        Thread t4 = new Thread(() -> {
            System.out.println("    Lambda läuft in: " + Thread.currentThread().getName());
        });
        t4.start();
        t4.join();
        
        // === Thread-Informationen ===
        System.out.println();
        System.out.println("  Thread-Informationen:");
        Thread current = Thread.currentThread();
        System.out.println("    Name: " + current.getName());
        System.out.println("    ID: " + current.getId());
        System.out.println("    Priorität: " + current.getPriority());
        System.out.println("    Daemon: " + current.isDaemon());
        System.out.println("    Verfügbare CPUs: " + Runtime.getRuntime().availableProcessors());
    }
}

/**
 * Thread durch Vererbung (Methode 1).
 */
class ZaehlerThread extends Thread {
    private String threadName;
    private int anzahl;
    
    public ZaehlerThread(String name, int anzahl) {
        this.threadName = name;
        this.anzahl = anzahl;
    }
    
    @Override
    public void run() {
        for (int i = 1; i <= anzahl; i++) {
            System.out.println("    " + threadName + ": " + i);
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }
}

/**
 * Runnable implementieren (Methode 2).
 */
class MeineAufgabe implements Runnable {
    private String name;
    
    public MeineAufgabe(String name) {
        this.name = name;
    }
    
    @Override
    public void run() {
        System.out.println("    " + name + " läuft in: " + Thread.currentThread().getName());
    }
}
