package com.javafleet.model;

/**
 * OrderStatus Enum
 * Tag 8 - JPA Relationen (OneToOne & ManyToOne)
 * 
 * Wird als @Enumerated(EnumType.STRING) in Order gespeichert
 * - STRING speichert "PENDING", "CONFIRMED", etc.
 * - ORDINAL würde 0, 1, 2, ... speichern (NIEMALS nutzen!)
 */
public enum OrderStatus {
    PENDING,     // Ausstehend
    CONFIRMED,   // Bestätigt
    SHIPPED,     // Versandt
    DELIVERED,   // Zugestellt
    CANCELLED    // Storniert
}
