package de.javafleet.sync;

import java.util.concurrent.*;
import java.util.concurrent.atomic.*;

/**
 * Demonstration: Atomic-Klassen.
 */
public class AtomicDemo {
    
    public static void demo() throws InterruptedException {
        System.out.println("  AtomicInteger Demo:");
        
        // === ATOMICINTEGER ===
        AtomicInteger counter = new AtomicInteger(0);
        
        ExecutorService executor = Executors.newFixedThreadPool(10);
        
        // 1000 Inkremente
        for (int i = 0; i < 1000; i++) {
            executor.execute(() -> counter.incrementAndGet());
        }
        
        executor.shutdown();
        executor.awaitTermination(5, TimeUnit.SECONDS);
        
        System.out.println("    Erwarteter Wert: 1000");
        System.out.println("    Tatsächlicher Wert: " + counter.get());
        
        // === ATOMIC OPERATIONEN ===
        System.out.println();
        System.out.println("  Atomic Operationen:");
        
        AtomicInteger value = new AtomicInteger(10);
        
        System.out.println("    Start: " + value.get());
        System.out.println("    getAndIncrement(): " + value.getAndIncrement() + " (jetzt: " + value.get() + ")");
        System.out.println("    incrementAndGet(): " + value.incrementAndGet());
        System.out.println("    addAndGet(5): " + value.addAndGet(5));
        System.out.println("    updateAndGet(x -> x * 2): " + value.updateAndGet(x -> x * 2));
        
        // === COMPARE AND SET ===
        System.out.println();
        System.out.println("  Compare-And-Set (CAS):");
        
        AtomicInteger cas = new AtomicInteger(100);
        
        boolean success1 = cas.compareAndSet(100, 200);  // Erwartet 100, setze 200
        System.out.println("    CAS(100, 200): " + success1 + ", Wert: " + cas.get());
        
        boolean success2 = cas.compareAndSet(100, 300);  // Erwartet 100, aber ist 200
        System.out.println("    CAS(100, 300): " + success2 + ", Wert: " + cas.get());
        
        // === WEITERE ATOMIC TYPEN ===
        System.out.println();
        System.out.println("  Weitere Atomic-Typen:");
        
        AtomicLong atomicLong = new AtomicLong(0);
        AtomicBoolean atomicBool = new AtomicBoolean(false);
        AtomicReference<String> atomicRef = new AtomicReference<>("initial");
        
        atomicLong.incrementAndGet();
        atomicBool.set(true);
        atomicRef.set("updated");
        
        System.out.println("    AtomicLong: " + atomicLong.get());
        System.out.println("    AtomicBoolean: " + atomicBool.get());
        System.out.println("    AtomicReference: " + atomicRef.get());
    }
}
