package de.javafleet.sync;

/**
 * Java Erweiterte Techniken - Tag 9: Synchronisation
 * 
 * In diesem Projekt lernst du:
 * - Race Conditions verstehen
 * - synchronized Blöcke und Methoden
 * - ReentrantLock und ReadWriteLock
 * - Atomic-Klassen
 * - Thread-sichere Collections
 * 
 * @author Java Fleet Systems Consulting
 */
public class Main {
    
    public static void main(String[] args) throws Exception {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Java Erweiterte Techniken - Tag 9: Synchronisation      ║");
        System.out.println("║  Java Fleet Systems Consulting                           ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        System.out.println();
        
        System.out.println("=== 1. Race Condition Demo ===");
        RaceConditionDemo.demo();
        
        System.out.println();
        System.out.println("=== 2. Synchronized Demo ===");
        SynchronizedDemo.demo();
        
        System.out.println();
        System.out.println("=== 3. Lock Demo ===");
        LockDemo.demo();
        
        System.out.println();
        System.out.println("=== 4. Atomic Demo ===");
        AtomicDemo.demo();
        
        System.out.println();
        System.out.println("=== 5. Thread-sichere Collections ===");
        ConcurrentCollectionsDemo.demo();
        
        System.out.println();
        System.out.println("=== 6. Deine Challenge ===");
        System.out.println("Öffne 'SyncChallenge' und löse die Aufgaben!");
        System.out.println();
        
        // Uncomment wenn fertig:
        // SyncChallenge.runChallenges();
        
        System.out.println("────────────────────────────────────────────────────────────");
        System.out.println("Geschafft! Weiter geht's mit Tag 10: Netzwerkprogrammierung");
    }
}
