package de.javafleet.sync;

import java.util.concurrent.*;
import java.util.concurrent.atomic.*;
import java.util.concurrent.locks.*;

/**
 * 🎯 CHALLENGE: Synchronisation meistern
 * 
 * Löse die folgenden Aufgaben, indem du die TODOs implementierst.
 */
public class SyncChallenge {
    
    public static void runChallenges() throws Exception {
        System.out.println("=== Synchronisation Challenges ===");
        System.out.println();
        
        level1();
        level2();
        level3();
    }
    
    // ========================================
    // 🟢 LEVEL 1: Grundlagen
    // ========================================
    
    static void level1() throws InterruptedException {
        System.out.println("--- Level 1: Grundlagen ---");
        
        // TODO 1.1: Mache diesen Zähler thread-safe mit synchronized
        SimpleCounter counter = new SimpleCounter();
        
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 1000; i++) {
            executor.execute(() -> counter.increment());
        }
        executor.shutdown();
        executor.awaitTermination(5, TimeUnit.SECONDS);
        
        System.out.println("  1.1 Zähler (soll 1000 sein): " + counter.getCount());
        
        // TODO 1.2: Nutze AtomicInteger statt synchronized
        AtomicCounter atomicCounter = new AtomicCounter();
        
        ExecutorService executor2 = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 1000; i++) {
            executor2.execute(() -> atomicCounter.increment());
        }
        executor2.shutdown();
        executor2.awaitTermination(5, TimeUnit.SECONDS);
        
        System.out.println("  1.2 AtomicCounter (soll 1000 sein): " + atomicCounter.getCount());
        
        System.out.println();
    }
    
    // ========================================
    // 🟡 LEVEL 2: Locks
    // ========================================
    
    static void level2() throws InterruptedException {
        System.out.println("--- Level 2: Locks ---");
        
        // TODO 2.1: Implementiere einen thread-safe Stack mit Lock
        // ThreadSafeStack<Integer> stack = new ThreadSafeStack<>();
        System.out.println("  2.1 Implementiere ThreadSafeStack!");
        
        // TODO 2.2: Nutze ReadWriteLock für einen Cache
        // Viele Leser, wenige Schreiber
        System.out.println("  2.2 Implementiere Cache mit ReadWriteLock!");
        
        System.out.println();
    }
    
    // ========================================
    // 🔵 LEVEL 3: Fortgeschritten
    // ========================================
    
    static void level3() throws Exception {
        System.out.println("--- Level 3: Fortgeschritten ---");
        
        // TODO 3.1: Implementiere einen ConnectionPool mit Semaphore
        // Max 3 gleichzeitige Verbindungen
        System.out.println("  3.1 Implementiere ConnectionPool mit Semaphore!");
        
        // TODO 3.2: Nutze CountDownLatch um auf mehrere Threads zu warten
        System.out.println("  3.2 Implementiere parallele Initialisierung!");
        
        // TODO 3.3: Finde und behebe den Deadlock
        // DeadlockExample deadlock = new DeadlockExample();
        System.out.println("  3.3 Behebe den Deadlock!");
        
        System.out.println();
    }
}

// ===== HILFSKLASSEN =====

class SimpleCounter {
    private int count = 0;
    
    // TODO: Mache thread-safe mit synchronized
    public void increment() {
        count++;
    }
    
    public int getCount() {
        return count;
    }
}

class AtomicCounter {
    // TODO: Nutze AtomicInteger
    private int count = 0;
    
    public void increment() {
        count++;
    }
    
    public int getCount() {
        return count;
    }
}

// TODO: Implementiere ThreadSafeStack<T>
// class ThreadSafeStack<T> { }

// TODO: Implementiere ThreadSafeCache
// class ThreadSafeCache { }

// TODO: Implementiere ConnectionPool
// class ConnectionPool { }
