package de.javafleet.network;

import java.net.URI;
import java.net.http.*;
import java.time.Duration;

/**
 * Demonstration: Moderner HttpClient (Java 11+).
 */
public class HttpClientDemo {
    
    public static void demo() throws Exception {
        // Client erstellen (wiederverwendbar!)
        HttpClient client = HttpClient.newBuilder()
            .version(HttpClient.Version.HTTP_2)
            .connectTimeout(Duration.ofSeconds(10))
            .build();
        
        // ===== GET REQUEST =====
        System.out.println("  GET Request:");
        
        HttpRequest getRequest = HttpRequest.newBuilder()
            .uri(URI.create("https://jsonplaceholder.typicode.com/posts/1"))
            .header("Accept", "application/json")
            .timeout(Duration.ofSeconds(30))
            .GET()
            .build();
        
        HttpResponse<String> getResponse = client.send(getRequest, 
            HttpResponse.BodyHandlers.ofString());
        
        System.out.println("    Status: " + getResponse.statusCode());
        System.out.println("    Body (gekürzt): " + 
            getResponse.body().substring(0, Math.min(100, getResponse.body().length())) + "...");
        
        // ===== POST REQUEST =====
        System.out.println();
        System.out.println("  POST Request:");
        
        String jsonBody = """
            {
                "title": "Test Post",
                "body": "Dies ist ein Test",
                "userId": 1
            }
            """;
        
        HttpRequest postRequest = HttpRequest.newBuilder()
            .uri(URI.create("https://jsonplaceholder.typicode.com/posts"))
            .header("Content-Type", "application/json")
            .POST(HttpRequest.BodyPublishers.ofString(jsonBody))
            .build();
        
        HttpResponse<String> postResponse = client.send(postRequest, 
            HttpResponse.BodyHandlers.ofString());
        
        System.out.println("    Status: " + postResponse.statusCode());
        System.out.println("    Body: " + postResponse.body());
        
        // ===== RESPONSE HEADERS =====
        System.out.println();
        System.out.println("  Response Headers (Auswahl):");
        getResponse.headers().map().entrySet().stream()
            .filter(e -> e.getKey().toLowerCase().startsWith("content"))
            .forEach(e -> System.out.println("    " + e.getKey() + ": " + e.getValue()));
    }
}
