package de.javafleet.network;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Demonstration: InetAddress für IP-Adressen.
 */
public class InetAddressDemo {
    
    public static void demo() {
        try {
            // Eigene Adresse
            System.out.println("  Lokale Adresse:");
            InetAddress localhost = InetAddress.getLocalHost();
            System.out.println("    Hostname: " + localhost.getHostName());
            System.out.println("    IP: " + localhost.getHostAddress());
            
            // Hostname auflösen
            System.out.println();
            System.out.println("  DNS-Auflösung (google.com):");
            InetAddress google = InetAddress.getByName("google.com");
            System.out.println("    Hostname: " + google.getHostName());
            System.out.println("    IP: " + google.getHostAddress());
            
            // Alle IPs für einen Host
            System.out.println();
            System.out.println("  Alle IPs für google.com:");
            InetAddress[] allAddresses = InetAddress.getAllByName("google.com");
            for (InetAddress addr : allAddresses) {
                System.out.println("    " + addr.getHostAddress());
            }
            
            // Loopback
            System.out.println();
            System.out.println("  Loopback-Adresse:");
            InetAddress loopback = InetAddress.getLoopbackAddress();
            System.out.println("    " + loopback.getHostAddress());
            
        } catch (UnknownHostException e) {
            System.out.println("  Fehler: " + e.getMessage());
        }
    }
}
