package de.javafleet.network;

import java.io.*;
import java.net.*;

/**
 * Echo-Client für den EchoServer.
 * 
 * Starte zuerst EchoServer, dann diesen Client.
 */
public class EchoClient {
    
    private static final String HOST = "localhost";
    private static final int PORT = 8080;
    
    public static void main(String[] args) {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Echo Client - Java Fleet Systems Consulting             ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        
        try (
            Socket socket = new Socket(HOST, PORT);
            BufferedReader in = new BufferedReader(
                new InputStreamReader(socket.getInputStream()));
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader console = new BufferedReader(
                new InputStreamReader(System.in))
        ) {
            System.out.println("Verbunden mit " + HOST + ":" + PORT);
            
            // Willkommensnachricht lesen
            String welcome = in.readLine();
            System.out.println("Server: " + welcome);
            System.out.println();
            System.out.println("Tippe Nachrichten (oder 'bye' zum Beenden):");
            System.out.println();
            
            String userInput;
            while ((userInput = console.readLine()) != null) {
                out.println(userInput);  // An Server senden
                String response = in.readLine();  // Antwort lesen
                System.out.println("Server: " + response);
                
                if ("bye".equalsIgnoreCase(userInput)) {
                    break;
                }
            }
            
            System.out.println("Verbindung beendet.");
            
        } catch (ConnectException e) {
            System.out.println("Fehler: Server nicht erreichbar!");
            System.out.println("Starte zuerst EchoServer.");
        } catch (IOException e) {
            System.out.println("Fehler: " + e.getMessage());
        }
    }
}
