package de.javafleet.network;

import java.io.*;
import java.net.*;
import java.util.concurrent.*;

/**
 * Einfacher Echo-Server mit Multi-Client Support.
 * 
 * Starte diesen Server, dann verbinde mit EchoClient.
 */
public class EchoServer {
    
    private static final int PORT = 8080;
    private static final ExecutorService executor = Executors.newFixedThreadPool(10);
    
    public static void main(String[] args) {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Echo Server - Java Fleet Systems Consulting             ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        
        try (ServerSocket serverSocket = new ServerSocket(PORT)) {
            System.out.println("Server läuft auf Port " + PORT);
            System.out.println("Warte auf Clients...");
            System.out.println();
            
            while (true) {
                Socket clientSocket = serverSocket.accept();
                System.out.println("Client verbunden: " + clientSocket.getInetAddress());
                
                // In separatem Thread behandeln
                executor.execute(new ClientHandler(clientSocket));
            }
            
        } catch (IOException e) {
            System.out.println("Server-Fehler: " + e.getMessage());
        }
    }
}

class ClientHandler implements Runnable {
    private final Socket socket;
    
    public ClientHandler(Socket socket) {
        this.socket = socket;
    }
    
    @Override
    public void run() {
        String clientId = socket.getInetAddress() + ":" + socket.getPort();
        
        try (
            BufferedReader in = new BufferedReader(
                new InputStreamReader(socket.getInputStream()));
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true)
        ) {
            out.println("Willkommen beim Echo-Server! Sende 'bye' zum Beenden.");
            
            String line;
            while ((line = in.readLine()) != null) {
                System.out.println("[" + clientId + "] " + line);
                
                if ("bye".equalsIgnoreCase(line)) {
                    out.println("Auf Wiedersehen!");
                    break;
                }
                
                out.println("Echo: " + line);
            }
            
        } catch (IOException e) {
            System.out.println("Client-Fehler: " + e.getMessage());
        } finally {
            try {
                socket.close();
            } catch (IOException e) {
                // Ignorieren
            }
            System.out.println("Client getrennt: " + clientId);
        }
    }
}
