package de.javafleet.network;

/**
 * Java Erweiterte Techniken - Tag 10: Netzwerkprogrammierung
 * 
 * In diesem Projekt lernst du:
 * - Socket-Kommunikation (Client/Server)
 * - HttpClient für REST-APIs
 * - Asynchrone HTTP-Requests
 * - JSON-Verarbeitung
 * 
 * @author Java Fleet Systems Consulting
 */
public class Main {
    
    public static void main(String[] args) throws Exception {
        System.out.println("╔══════════════════════════════════════════════════════════╗");
        System.out.println("║  Java Erweiterte Techniken - Tag 10: Netzwerk            ║");
        System.out.println("║  Java Fleet Systems Consulting                           ║");
        System.out.println("╚══════════════════════════════════════════════════════════╝");
        System.out.println();
        
        System.out.println("=== 1. InetAddress Demo ===");
        InetAddressDemo.demo();
        
        System.out.println();
        System.out.println("=== 2. HttpClient Demo ===");
        HttpClientDemo.demo();
        
        System.out.println();
        System.out.println("=== 3. Async HTTP Demo ===");
        AsyncHttpDemo.demo();
        
        System.out.println();
        System.out.println("=== 4. Socket-Server Demo ===");
        System.out.println("  Starte separat: EchoServer.main()");
        System.out.println("  Dann: EchoClient.main()");
        
        System.out.println();
        System.out.println("=== 5. Deine Challenge ===");
        System.out.println("Öffne 'NetworkChallenge' und löse die Aufgaben!");
        System.out.println();
        
        // Uncomment wenn fertig:
        // NetworkChallenge.runChallenges();
        
        System.out.println("────────────────────────────────────────────────────────────");
        System.out.println("🎉 GRATULATION! Du hast den Kurs abgeschlossen! 🎉");
    }
}
